# Grafowe sieci neuronowe. Teoria i praktyka — repozytorium

Kod i notatniki Jupyter towarzyszące książce *Grafowe sieci neuronowe. Teoria i praktyka* (Filip Wójcik, Helion).

📖 [Oficjalna strona książki - Wydawnictwo Helion](https://helion.pl/ksiazki/grafowe-sieci-neuronowe-teoria-i-praktyka-filip-wojcik,siegra.htm)

📂 [Repozytorium kodu](https://github.com/maddataanalyst/grafowe_sieci_neuronowe)

🌐 [Strona domowa autora](https://filip-wojcik.com)


> **Aktualizacje**
> 
> Zachęcam do śledzenia aktualizacji kodu książki w repozytorium na Githubie. Biblioteki i narzędzia nieustannie się zmieniają.
> Aby zapewnić aktualność materiałow będę starał się regularnie poprawiać kod i notatniki, zapewniając ich kompatybliność z 
> najnowszymi wersjami, oraz pokazując ciekawe, nowe funkcje.


## O książce

Książka wprowadza do metod uczenia głębokiego przeznaczonych do analizy danych o strukturze grafowej. Omawia zarówno podstawy teoretyczne, jak i aspekty praktyczne: modelowanie problemów w postaci grafów, projektowanie warstw splotu grafowego, dobre praktyki implementacyjne oraz procedury treningowe.

### Zakres tematyczny

- Narzędzia klasycznej analizy grafów w Pythonie oraz wybrane zagadnienia teorii grafów
- Wprowadzenie do GNN i architektury przekazywania wiadomości (*message-passing neural networks*)
- Przegląd warstw splotu grafowego (GCN, GraphSAGE, GAT, GIN) i praktyki ich projektowania
- Aspekty treningu sieci GNN
- Praktyczne przykłady zastosowań

## Struktura repozytorium

| Katalog | Zawartość |
|---------|-----------|
| `rozdzial_2_analiza_grafow/` | Klasyczna analiza grafów, własności liczbowe, izomorfizm, test Weisfeilera–Lehmana |
| `rozdzial_3_sieci_gnn_wprowadzenie/` | Wprowadzenie do GNN, uogólniona architektura, przykłady implementacji |
| `rozdzial_4_przeglad_warstw_gnn/` | Przegląd warstw GNN z przykładami implementacyjnymi |
| `rozdzial_5_wybrane_aspekty_treningu/` | Dobór hiperparametrów, metryki, stabilność uczenia |
| `rozdzial_6_zastosowania_sieci_gnn/` | Klasyfikacja wierzchołków, krawędzi, grafów; system rekomendacyjny |
| `utils/` | Funkcje pomocnicze (wizualizacje itp.) |

## Wymagania

- **Python ≥ 3.11**
- **uv** — menedżer zależności ([instrukcja instalacji](https://docs.astral.sh/uv/getting-started/installation/))
- **GPU z CUDA 12.8** (opcjonalnie) — konfiguracja domyślna; dla CPU lub innej wersji CUDA zob. sekcję [Konfiguracja bez CUDA / z inną wersją CUDA](#konfiguracja-bez-cuda--z-inną-wersją-cuda)

## Instalacja

### 1. Zainstaluj `uv`

Szczegółowa instrukcja: [docs.astral.sh/uv/getting-started/installation](https://docs.astral.sh/uv/getting-started/installation/)

### 2. Pobierz repozytorium

```bash
git clone https://github.com/maddataanalyst/grafowe_sieci_neuronowe.git
cd grafowe_sieci_neuronowe
```

Alternatywnie: pobierz i rozpakuj archiwum ZIP, następnie przejdź do rozpakowanego katalogu.

### 3. Zsynchronizuj środowisko

```bash
uv sync --all-extras
```

To polecenie:
- utworzy środowisko wirtualne w `.venv/`
- zainstaluje wszystkie zależności, w tym opcjonalne biblioteki PyG

### 4. Uruchom środowisko pracy

**JupyterLab** (przez `uv run`):

```bash
uv run jupyter lab
```

**VSCode / PyCharm / inne IDE:**

Wybierz interpreter Pythona ze środowiska projektu `.venv/`:
- VSCode: `Ctrl+Shift+P` → *Python: Select Interpreter* → wybierz `.venv/bin/python` (Linux/macOS) lub `.venv\Scripts\python.exe` (Windows)
- PyCharm: *Settings* → *Project* → *Python Interpreter* → *Add Interpreter* → *Existing* → wskaż `.venv/`

**Ręczna aktywacja środowiska** (jeśli potrzebujesz uruchomić polecenia bezpośrednio):

```bash
# Linux / macOS
source .venv/bin/activate

# Windows (PowerShell)
.venv\Scripts\Activate.ps1

# Windows (cmd)
.venv\Scripts\activate.bat
```

Po aktywacji możesz uruchamiać `python`, `jupyter lab` itp. bezpośrednio.

## Konfiguracja bez CUDA / z inną wersją CUDA

Domyślna konfiguracja projektu zakłada CUDA 12.8. Jeśli pracujesz na CPU lub z inną wersją CUDA, musisz zmodyfikować plik `pyproject.toml`.

### Wariant CPU-only

Zmień sekcję `[tool.uv]`:

```toml
[tool.uv]
find-links = [
    "https://download.pytorch.org/whl/cpu",
    "https://data.pyg.org/whl/torch-2.8.0+cpu.html",
]
```

Oraz źródło PyTorch:

```toml
[tool.uv.sources]
torch = { index = "torch-cpu" }

[[tool.uv.index]]
name = "torch-cpu"
url = "https://download.pytorch.org/whl/cpu"
explicit = true
```

### Inna wersja CUDA

Dostosuj adresy `find-links` i indeks do swojej wersji CUDA. Dostępne warianty:
- `cu126` (CUDA 12.6)
- `cu128` (CUDA 12.8)
- `cpu`

Przykład dla CUDA 12.6:

```toml
[tool.uv]
find-links = [
    "https://download.pytorch.org/whl/cu126",
    "https://data.pyg.org/whl/torch-2.8.0+cu126.html",
]
```

Po modyfikacji `pyproject.toml` usuń plik `uv.lock` i wykonaj ponownie `uv sync --all-extras`.

## Rozwiązywanie problemów

### Problemy z bibliotekami PyG

Biblioteki opcjonalne PyG (`pyg-lib`, `torch-scatter`, `torch-sparse`, `torch-cluster`, `torch-spline-conv`) są najczęstszym źródłem problemów instalacyjnych. Wynikają one z konieczności dopasowania wersji PyTorch i CUDA.

Jeśli instalacja automatyczna nie powiedzie się:

1. Sprawdź zgodność wersji w [dokumentacji PyG](https://pytorch-geometric.readthedocs.io/en/latest/install/installation.html)
2. Upewnij się, że adresy w `find-links` odpowiadają Twojej wersji PyTorch i CUDA
3. W ostateczności zainstaluj biblioteki ręcznie po aktywacji środowiska:

```bash
source .venv/bin/activate  # Linux/macOS
# lub: .venv\Scripts\activate  # Windows

pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv \
    -f https://data.pyg.org/whl/torch-2.8.0+cu128.html
```

### Problemy na Windows

Windows może wymagać dodatkowej konfiguracji. Zalecane jest używanie WSL2 z Ubuntu dla najbardziej przewidywalnego środowiska. Alternatywnie upewnij się, że masz zainstalowane:
- [Visual C++ Build Tools](https://visualstudio.microsoft.com/visual-cpp-build-tools/)
- Odpowiednie sterowniki NVIDIA i CUDA Toolkit (jeśli używasz GPU)

### Problemy na macOS

macOS nie wspiera CUDA. Użyj konfiguracji CPU-only (zob. wyżej). Na Apple Silicon (M1/M2/M3) PyTorch wykorzystuje Metal Performance Shaders (MPS), ale niektóre operacje PyG mogą nie być wspierane.

## Powtarzalność wyników

W materiałach zastosowano mechanizmy zapewniające powtarzalność: ustalanie ziaren losowości, tryb deterministyczny w PyTorch Lightning. Mimo to **pełna reprodukowalność może nie być osiągalna** na GPU ze względu na niezdeterminowane operacje CUDA. Uzyskiwane wyniki powinny być zbliżone do prezentowanych. Szczegóły: [PyTorch Reproducibility](https://pytorch.org/docs/stable/notes/randomness.html).

## Uwagi

### Notatniki Jupyter

Materiały mają postać notatników Jupyter — są doskonałą pomocą dydaktyczną i ułatwiają eksperymentowanie. Można z nimi pracować w JupyterLab, VSCode (z [rozszerzeniem Jupyter](https://marketplace.visualstudio.com/items?itemName=ms-toolsai.jupyter)), PyCharm Professional lub innym IDE obsługującym format `.ipynb`. Konfigurację środowiska opisano w sekcji [Uruchom środowisko pracy](#4-uruchom-środowisko-pracy).

W produkcyjnych zastosowaniach ML notatniki są jednak zastępowane przez skrypty i potoki przetwarzania (*pipeline*), łatwiejsze w debugowaniu i testowaniu.

### Konwencje terminologiczne

W książce przyjęto następujące konwencje:
- Terminy z polskimi odpowiednikami są tłumaczone z podaniem oryginału w nawiasie
- Terminy bez ugruntowanego tłumaczenia mają proponowany polski odpowiednik
- Powszechne anglicyzmy branżowe (*batch*, *dropout*, *dataset*) są używane w oryginale, zapisane kursywą
- Nazwy modeli i skróty pozostają w oryginale (SAGE, LSTM, GIN)
- Kod źródłowy jest pisany w języku angielskim; komentarze — po polsku

## Licencja

Zob. plik `LICENSE`.
