/*
 * (C) Copyright 2021 Boni Garcia (https://bonigarcia.github.io/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package io.github.bonigarcia.webdriver.seljup.ch06.cloud_providers;

import static org.assertj.core.api.Assertions.assertThat;
import static org.assertj.core.api.Assumptions.assumeThat;

import java.net.MalformedURLException;
import java.net.URL;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

import io.github.bonigarcia.seljup.DriverCapabilities;
import io.github.bonigarcia.seljup.DriverUrl;
import io.github.bonigarcia.seljup.SeleniumJupiter;

@ExtendWith(SeleniumJupiter.class)
class PerfectoSelJupTest {

    @DriverUrl
    URL remoteUrl;

    @DriverCapabilities
    DesiredCapabilities capabilities;

    @BeforeEach
    void setup() throws MalformedURLException {
        String cloudName = System.getProperty("perfectoCloudName");
        String securityToken = System.getProperty("perfectoSecurityToken");

        // Innym sposobem odczytania wartości cloudname i tokenu jest skorzystanie ze zmiennych środowiskowych:
        // String cloudName = System.getenv("PERFECTO_CLOUD_NAME");
        // String securityToken = System.getenv("PERFECTO_SECURITY_TOKEN");

        assumeThat(cloudName).isNotEmpty();
        assumeThat(securityToken).isNotEmpty();

        capabilities = new DesiredCapabilities();
        capabilities.setCapability("browserName", "Chrome");
        capabilities.setCapability("browserVersion", "latest");
        capabilities.setCapability("platformName", "Windows");
        capabilities.setCapability("platformVersion", "10");
        capabilities.setCapability("location", "US East");
        capabilities.setCapability("resolution", "1024x768");
        capabilities.setCapability("securityToken", securityToken);

        remoteUrl = new URL(String.format(
                "http://%s.perfectomobile.com/nexperience/perfectomobile/wd/hub",
                cloudName));
    }

    @Test
    void testPerfecto(RemoteWebDriver driver) {
        driver.get("https://bonigarcia.dev/selenium-webdriver-java/");
        assertThat(driver.getTitle()).contains("Selenium WebDriver");
    }

}
