/*
 * (C) Copyright 2021 Boni Garcia (https://bonigarcia.github.io/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package io.github.bonigarcia.webdriver.junit4.ch06.cloud_providers;

import static org.assertj.core.api.Assertions.assertThat;
import static org.assertj.core.api.Assumptions.assumeThat;

import java.net.MalformedURLException;
import java.net.URL;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class PerfectoJUnit4Test {

    WebDriver driver;

    @Before
    public void setup() throws MalformedURLException {
        String cloudName = System.getProperty("perfectoCloudName");
        String securityToken = System.getProperty("perfectoSecurityToken");

        // Innym sposobem odczytania wartości cloudname i tokenu jest skorzystanie ze zmiennych środowiskowych:
        // String cloudName = System.getenv("PERFECTO_CLOUD_NAME");
        // String securityToken = System.getenv("PERFECTO_SECURITY_TOKEN");

        assumeThat(cloudName).isNotEmpty();
        assumeThat(securityToken).isNotEmpty();

        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setCapability("browserName", "Chrome");
        capabilities.setCapability("browserVersion", "latest");
        capabilities.setCapability("platformName", "Windows");
        capabilities.setCapability("platformVersion", "10");
        capabilities.setCapability("location", "US East");
        capabilities.setCapability("resolution", "1024x768");
        capabilities.setCapability("securityToken", securityToken);

        URL remoteUrl = new URL(String.format(
                "http://%s.perfectomobile.com/nexperience/perfectomobile/wd/hub",
                cloudName));
        driver = new RemoteWebDriver(remoteUrl, capabilities);
    }

    @After
    public void teardown() {
        if (driver != null) {
            driver.quit();
        }
    }

    @Test
    public void testPerfecto() {
        driver.get("https://bonigarcia.dev/selenium-webdriver-java/");
        assertThat(driver.getTitle()).contains("Selenium WebDriver");
    }

}
