/*
 *  Copyright (c) 2015 The WebRTC project authors. Wszystkie prawa zastrzeżone.
 *
 *  Wykorzystanie tego kodu źródłowego podlega licencji opartej na BSD
 *  którą można znaleźć w pliku LICENSE w katalogu głównym projektu. 
 */
'use strict';

// Umieszczenie wszystkich zmiennych w zakresie globalnym, by były dostępne dla konsoli przeglądarki.
const constraints = window.constraints = {
  audio: true,
  video: true
};

function handleSuccess(stream) {
  const video = document.querySelector('video');
  const videoTracks = stream.getVideoTracks();
  console.log('Got stream with constraints:', constraints);
  document.getElementById("video-device").innerText = `Using video device: ${videoTracks[0].label}`;
  window.stream = stream; // make variable available to browser console
  video.srcObject = stream;
}

function handleError(error) {
  if (error.name === 'ConstraintNotSatisfiedError') {
    const v = constraints.video;
    errorMsg(`The resolution ${v.width.exact}x${v.height.exact} px is not supported by your device.`);
  } else if (error.name === 'PermissionDeniedError') {
    errorMsg('Permissions have not been granted to use your camera and ' +
      'microphone, you need to allow the page access to your devices in ' +
      'order for the demo to work.');
  }
  errorMsg(`getUserMedia error: ${error.name}`, error);
}

function errorMsg(msg, error) {
  const errorElement = document.querySelector('#errorMsg');
  errorElement.innerHTML += `<p>${msg}</p>`;
  if (typeof error !== 'undefined') {
    console.error(error);
  }
}

async function init(e) {
  try {
    const stream = await navigator.mediaDevices.getUserMedia(constraints);
    handleSuccess(stream);
    e.target.disabled = true;
  } catch (e) {
    handleError(e);
  }
}

document.querySelector('#start').addEventListener('click', e => init(e));