package com.secookbook.examples.chapter14.android;

import java.net.URL;

import io.appium.java_client.android.AndroidDriver;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.junit.*;

import static org.junit.Assert.*;

public class MobileBmiCalculatorTest {

	private WebDriver driver;

	@Before
	public void setUp() throws Exception {
		// Ustawienie żądanych opcji dla urządzenia z systemem Android
		DesiredCapabilities caps = DesiredCapabilities.android();
		caps.setCapability("deviceOrientation", "portrait");
		caps.setCapability("platformVersion", "4.4");
		caps.setCapability("platformName", "Android");
		caps.setCapability("browserName", "Chrome");

		// Utworzenie egzemplarza AndroidDriver do testowania na platformie Android.
		// Nawiązanie połączenia z lokalnym serwerem Appium uruchomionym na innym komputerze.
		// Do testowania aplikacji webowej użyjemy typu WebElement
		driver = new AndroidDriver<WebElement>(new URL(
				"http://192.168.0.101:4723/wd/hub"), caps);

		// Otwarcie aplikacji mobilnej Kalkulator BMI
		driver.get("http://cookbook.seleniumacademy.com/mobilebmicalculator.html");
	}

	@Test
	public void testMobileBmiCalculator() throws Exception {
		// Pobranie pola wzrostu i ustawienie jego wartości
		WebElement heightField = driver.findElement(By.name("heightCMS"));
		heightField.sendKeys("181");

		// Pobranie pola wagi i ustawienie jego wartości
		WebElement weightField = driver.findElement(By.name("weightKg"));
		heightField.sendKeys("80");

		//Kliknięcie przycisku Oblicz
		WebElement calculateButton = driver.findElement(By.id("Oblicz"));
		calculateButton.click();

		// Sprawdzenie współczynnika Bmi
		WebElement bmiLabel = driver.findElement(By.name("bmi"));
		assertEquals("24.4", bmiLabel.getAttribute("value"));

		// Sprawdzenie kategorii BMI
		WebElement bmiCategoryLabel = driver.findElement(By.name("bmi_category"));
		assertEquals("Normal", bmiCategoryLabel.getAttribute("value"));
	}

	@After
	public void tearDown() throws Exception {
		// Zamknięcie przeglądarki
		driver.quit();
	}
}

