package com.secookbook.examples.chapter06;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

import java.util.List;

public class FramesTest {

	public static WebDriver driver;

	@BeforeClass
	public static void setUp() {
		driver = new FirefoxDriver();
		driver.get("http://cookbook.seleniumacademy.com/Frames.html");
		driver.manage().window().maximize();
	}

	@Test
	public void testFrameWithIdOrName() {
		try {

			// Uaktywnij ramkę po lewej stronie za pomocą atrybutu id
			driver.switchTo().frame("left");

			// Pobierz element z ramki po lewej stronie i zweryfikuj jego
			// zawartości
			WebElement msg = driver.findElement(By.tagName("p"));
			assertEquals("To jest ramka po lewej", msg.getText());
		} finally {
			// Uaktywnij stronę. Spowoduje to przeniesienie kontekstu z ramki
			// z powrotem na stronę
			driver.switchTo().defaultContent();
		}

		try {
			// Uaktywnienie ramki po prawej stronie przy użyciu jej atrybutu name
			driver.switchTo().frame("right");

			// Pobierz element z ramki po prawej stronie i zweryfikuj jego
			// zawartość
			WebElement msg = driver.findElement(By.tagName("p"));
			assertEquals ("To jest ramka po prawej", msg.getText());
		} finally {
			// Uaktywnij stronę. Spowoduje to przeniesienie kontekstu z ramki
			// z powrotem na stronę
			driver.switchTo().defaultContent();
		}
	}

	@Test
	public void testFrameByIndex() {
		try {
			// Uaktywnij środkową ramkę przy użyciu jej indeksu. Indeks zaczyna się od 0
			driver.switchTo().frame(1);

			// Pobierz element odpowiadający środkowej ramce i zweryfikuj jego
			// zawartość
			WebElement msg = driver.findElement(By.tagName("p"));
			assertEquals("Ta ramka nie ma identyfikatora, ani nazwy", msg.getText());
		} finally {
			// Uaktywnij stronę. Spowoduje to przeniesienie kontekstu z ramki
			// z powrotem na stronę
			driver.switchTo().defaultContent();
		}
	}

	@Test
	public void testFrameByContents() {
		// Utworzenie reprezentacji wszystkich ramek na stronie utworzonych z wykorzystaniem znacznika <frame>
		List<WebElement> frames = driver.findElements(By.tagName("frame"));

		// W tym przykładzie środkowa ramka jest aktywowana poprzez sprawdzenie jej 
		// zawartości
		// Uaktywnienie ramki i sprawdzenie, czy zawiera żądaną zawartość. Jeśli zostanie znaleziona,
		// to operacje będą wykonane
		// Jeśli nie, nastąpi przejście do strony i kontynuowanie sprawdzania
		try {
			for (WebElement frame : frames) {
				// Metoda switchTo().frame() oprócz atrybutu name, id i indeksu akceptuje również elementy ramek
				driver.switchTo().frame(frame);
				String title = driver.getTitle();
				if (title.equals("Ramka B")) {
					WebElement msg = driver.findElement(By.tagName("p"));
					assertEquals("To jest ramka po lewej", msg.getText());
					break;
				} else
					driver.switchTo().defaultContent();
			}
		} finally {
			// Uaktywnij stronę. Spowoduje to przeniesienie kontekstu z ramki
			// z powrotem na stronę
			driver.switchTo().defaultContent();
		}
	}

	@Test
	Public void testIFrame() {}
		// Przechowaj uchwyt bieżącego okna sterownika
		String currentWindow = driver.getWindowHandle();
		
		// Ramka po prawej stronie zawiera zagnieżdżony element iframe zawierający przycisk
		// śledzenia Twittera
		// Uaktywnienie ramki po prawej stronie przy użyciu jej atrybutu name
		try {
			driver.switchTo().frame("right");

			// Uzyskanie reprezentacji elementu iframe
			WebElement twitterFrame = driver.findElement(By.tagName("iframe"));

			try {
				// Uaktywnienie elementu iframe
				driver.switchTo().frame(twitterFrame);
				// Uzyskaj reprezentację przycisku śledzenia Twittera z elementu iframe i kliknij go.
				// Po kliknięciu wyświetli się okno Popup
				WebElement button = driver.findElement(By.id("follow-button"));
				button.click();

				try {
					// Okno popup Twittera nie ma atrybutów name, ani title.
					// Skrypt uzyska uchwyty wszystkich otwartych okien.
					// Żądane okno zostanie aktywowane na podstawie sprawdzenia jego tytułu

					for (String windowId : driver.getWindowHandles()) {
						driver.switchTo().window(windowId);
						if (driver.getTitle().equals(
								"Unmesh Gundecha (@upgundecha) on Twitter")) {
							assertTrue("Znaleziono okno popup logowania do Twittera", true);
							driver.close();
							break;
						}

					}
				} finally {
					// Przełączenie się do oryginalnego okna sterownika
					driver.switchTo().window(currentWindow);
				}
			} finally {
				// Przełączenie się do strony z ramki
				driver.switchTo().defaultContent();
			}

		} finally {
			// Przełączenie się do strony z ramki
			driver.switchTo().defaultContent();
		}
	}

	@AfterClass
	public static void tearDown() {
		// Zamknij nadrzędne okno popup
		driver.close();
		driver.quit();
	}
}

