package com.secookbook.examples.chapter14.android;

import java.util.HashMap;
import java.util.Map;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.junit.*;

import static org.junit.Assert.*;

public class ChromeMobileEmulationTest {

	private WebDriver driver;

	@Before
	public void setUp() throws Exception {
		
		Map<String, String> mobileEmulation = new HashMap<String, String>();
		mobileEmulation.put("deviceName", "Apple iPhone 6");

		Map<String, Object> chromeOptions = new HashMap<String, Object>();
		chromeOptions.put("mobileEmulation", mobileEmulation);
		DesiredCapabilities capabilities = DesiredCapabilities.chrome();
		capabilities.setCapability(ChromeOptions.CAPABILITY, chromeOptions);
		WebDriver driver = new ChromeDriver(capabilities);
		
		// Otwarcie aplikacji mobilnej Kalkulator BMI
		driver.get("http://cookbook.seleniumacademy.com/mobilebmicalculator.html");
	}

	@Test
	public void testMobileBmiCalculator() throws Exception {
		// Pobranie pola wzrostu i ustawienie jego wartości
		WebElement heightField = driver.findElement(By.name("heightCMS"));
		heightField.sendKeys("181");

		// Pobranie pola wagi i ustawienie jego wartości
		WebElement weightField = driver.findElement(By.name("weightKg"));
		heightField.sendKeys("80");

		//Kliknięcie przycisku Oblicz
		WebElement calculateButton = driver.findElement(By.id("Oblicz"));
		calculateButton.click();

		// Sprawdzenie współczynnika Bmi
		WebElement bmiLabel = driver.findElement(By.name("bmi"));
		assertEquals("24.4", bmiLabel.getAttribute("value"));

		// Sprawdzenie kategorii BMI
		WebElement bmiCategoryLabel = driver.findElement(By.name("bmi_category"));
		assertEquals("Normal", bmiCategoryLabel.getAttribute("value"));
	}

	@After
	public void tearDown() throws Exception {
		// Zamknięcie przeglądarki
		driver.quit();
	}
}

