package com.secookbook.examples.chapter09;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;

import static org.junit.Assert.*;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class WebTableTests {
	WebDriver driver;

	@Before
	public void setUp() {
		// Utwórz nowy egzemplarz sterownika przeglądarki Firefox
		driver = new FirefoxDriver();
		driver.get("http://cookbook.seleniumacademy.com/Locators.html");
	}

	@Test
	public void testWebTableTest() {
		// Pobranie elementu table jako egzemplarza klasy WebTable z wykorzystaniem selektora  CSS
		WebTable table = new WebTable(driver.findElement(By
				.cssSelector("div.cart-info table")));

		// Zweryfikowanie, czy zawiera trzy wiersze
		assertEquals(3, table.getRowCount());
		// Zweryfikowanie, czy zawiera sześć kolumn
		assertEquals(5, table.getColumnCount());
		//Sprawdzenie, czy w drugiej komórce trzeciego wiersza występuje określona wartość
		assertEquals("iPhone", table.getCellData(3, 1));

		// Pobranie edytora komórki i wprowadzenie pewnej wartości
		WebElement cellEdit = table.getCellEditor(3, 3, 0);
		cellEdit.clear();
		cellEdit.sendKeys("2");
	}

	@After
	public void tearDown() {
		// Zamknięcie przeglądarki
		driver.quit();
	}
}

