package com.secookbook.examples.chapter08.tests;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;

import static org.junit.Assert.*;

import com.secookbook.examples.chapter08.pageobjects.BmiCalcPage;

public class BmiCalculatorTests {

	private WebDriver driver;

	@Before
	public void setUp() {
		driver = new ChromeDriver();
	}

	@Test
	public void testBmiCalculation() {
		//Utworzenie egezmplarza klasy strony Kalkulator Bmi
		//i przekazanie obiektu driver
		BmiCalcPage bmiCalcPage = new BmiCalcPage(driver);

		// Otwarcie aplikacji Kalkulator BMI
		bmiCalcPage.get();

		// Obliczenie Bmi przez podanie wartości wzrostu i wagi
		bmiCalcPage.calculateBmi("181", "80");

		//Zweryfikowanie wartości BMI i kategorii Bmi
		assertEquals("24.4", bmiCalcPage.getBmi());
		assertEquals ("Waga normalna", bmiCalcPage.getBmiCategory());
	}

	@After
	public void tearDown() {
		driver.quit();
	}
}

