package com.secookbook.examples.chapter07;

import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;
import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized.Parameters;
import org.junit.runners.Parameterized;

import static org.junit.Assert.*;

import java.util.Arrays;
import java.util.List;

@RunWith(Parameterized.class)
public class SimpleDDT {

	private static WebDriver driver;

	private String height;
	private String weight;
	private String bmi;
	private String bmiCategory;

	@Parameters
	public static List<String[]> testData() {
		return Arrays.asList(new String[][] {
				{ "160", "45", "17.6", "Niedowaga" },
				{ "168", "70", "24.8", "Waga normalna" },
				{ "181", "89", "27.2", "Nadwaga" },
				{ "178", "100", "31.6", "Otyłość" } });
	}

	public SimpleDDT(String height, String weight, String bmi,
			String bmiCategory) {
		this.height = height;
		this.weight = weight;
		this.bmi = bmi;
		this.bmiCategory = bmiCategory;
	}

	@BeforeClass
	public static void setUp() throws Exception {
		// Utwórz nowy egzemplarz sterownika przeglądarki Firefox
		driver = new FirefoxDriver();
		driver.get("http://cookbook.seleniumacademy.com/bmicalculator.html");
	}

	@Test
	public void testBMICalculator() throws Exception {
		// Pobierz element opisujący wzrost, i ustaw wartość za pomocą zmiennej height
		WebElement heightField = driver.findElement(By.name("heightCMS"));
		heightField.clear();
		heightField.sendKeys(height);

		// Pobierz element opisujący wagę i ustaw wartość za pomocą zmiennej weight
		WebElement weightField = driver.findElement(By.name("weightKg"));
		weightField.clear();
		weightField.sendKeys(weight);

		// Kliknij przycisk Oblicz
		WebElement calculateButton = driver.findElement(By.id("Oblicz"));
		calculateButton.click();

		// Pobierz element opisujący Bmi i sprawdź jego wartość porównując ze zmienną bmi
		WebElement bmiLabel = driver.findElement(By.name("bmi"));
		assertEquals(bmi, bmiLabel.getAttribute("value"));

		// Pobierz element reprezentujący kategorię BMI i sprawdź jego wartość używając
		// zmiennej bmiCategory
		WebElement bmiCategoryLabel = driver.findElement(By
				.name("bmi_category"));
		assertEquals(bmiCategory, bmiCategoryLabel.getAttribute("value"));
	}

	@AfterClass
	public static void tearDown() throws Exception {
		driver.quit();
	}
}

