package com.secookbook.examples.chapter05;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;

import org.junit.Test;
import static org.junit.Assert.*;

import java.util.concurrent.TimeUnit;

public class ImplicitWaitTest {
	@Test
	public void testWithOutWait() {

		WebDriver driver = new FirefoxDriver();
		// Uruchomienie przykładowej aplikacji Ajax
		driver.get("http://cookbook.seleniumacademy.com/AjaxDemo.html");

		try {
			// Uzyskanie łącza do Strony 4 i kliknięcie go
			driver.findElement(By.linkText("Strona 4")).click();

			// Pobierz element o identyfikatorze page4 i sprawdź jego tekst
			// Test zakończy się niepowodzeniem. Zgłosi wyjątek NoSuchElementException
			//bez niejawnego oczekiwania
			WebElement message = driver.findElement(By.id("page4"));
			assertTrue(message.getText().contains("Nunc nibh tortor"));
		} finally {
			driver.quit();
		}
	}

	@Test
	public void testWithImplicitWait() {
		WebDriver driver = new FirefoxDriver();
		// Uruchomienie przykładowej aplikacji Ajax
		driver.get("http://cookbook.seleniumacademy.com/AjaxDemo.html");

		// Ustawienie czasu niejawnego oczekiwania na 10 sekund
		driver.manage().timeouts().implicitlyWait(10, TimeUnit.SECONDS);

		try {
			// Uzyskanie łącza do Strony 4 i kliknięcie go
			driver.findElement(By.linkText("Strona 4")).click();

			// Pobierz element o identyfikatorze page4 i sprawdź jego tekst
			WebElement message = driver.findElement(By.id("page4"));
			assertTrue(message.getText().contains("Nunc nibh tortor"));
		} finally {
			driver.quit();
		}
	}
}

