package com.secookbook.examples.chapter03;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

public class CheckBoxTest {

    private WebDriver driver;

    @Before
    public void setUp() {
        driver = new FirefoxDriver();
        driver.get("http://cookbook.seleniumacademy.com/Config.html");
    }
    
 	@Test
    public void testCheckBox() {
 		// Pobranie obiektu WebElement reprezentującego pole wyboru na podstawie jego atrybutu value
 		WebElement airbags = driver.findElement(By.xpath("//input[@value='Airbags']"));
 		
 		// Sprawdzenie, czy pole wyboru jest już zaznaczone. W przeciwnym razie zaznaczenie pola wyboru
 		// przez wywołanie metody click()
 		if (!airbags.isSelected()) {
 			airbags.click();
 		}
 		
 		//Zweryfikowanie, czy pole wyboru jest zaznaczone
 		assertTrue(airbags.isSelected());

 		// Sprawdzenie, czy pole wyboru jest zaznaczone. Jeśli tak, to usuwamy jego zaznaczenie
 		// przez wywołanie metody click()
 		if (airbags.isSelected()) {
 			airbags.click();
 		}
 		
 		//Zweryfikowanie, czy pole wyboru jest niezaznaczone.
 		assertFalse(airbags.isSelected());
    }
 	
    @After
    public void tearDown() {
        driver.quit();
    }
}
