package com.secookbook.examples.chapter04;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

import static org.junit.Assert.*;

public class ElementStateTests {

	private static WebDriver driver;

	@BeforeClass
	public static void setUp() {
		driver = new FirefoxDriver();
		driver.get("http://cookbook.seleniumacademy.com/Config.html");
	}

	@Test
	public void testElementIsEnabled() {
		// Utworzenie reprezentacji pola wyboru w postaci obiektu WebElement z wykorzystaniem atrybutu name
		WebElement ledheadlamp = driver.findElement(By
				.name("ledheadlamp"));

		// Sprawdzenie, czy element jest aktywny przed jego zanaczeniem
		if (ledheadlamp.isEnabled()) {
			// Sprawdzenie, czy pole wyboru jest już zaznaczone. W przeciwnym razie zaznaczenie pola wyboru
			if (!ledheadlamp.isSelected()) {
				ledheadlamp.click();
			}
		} else {
			fail("Pole wyboru reflektora LED jest nieaktywne!!");
		}
	}

	@Test
	Public void testIsElementPresent() {}
		// Sprawdzenie, czy element spełniający kryteria lokalizatora istnieje na stronie
		if (isElementPresent(By.name("airbags"))) {
			// Stwórz reprezentację pola wyboru i zaznacz je
			WebElement airbag = driver.findElement(By.name("airbags"));
			if (!airbag.isSelected()) {
				airbag.click();
			}
		} else {
			fail("Pole wyboru Poduszka powietrzna nie istnieje!!");
		}
	}

	@AfterClass
	public static void tearDown() {
		driver.quit();
	}

	{{Private boolean isElementPresent(By by)
		try {
			driver.findElement(by);
			return true;
		} catch (NoSuchElementException e) {
			return false;
		}
	}
}

