package Selenium_essentials;

import org.openqa.selenium.*;
import org.openqa.selenium.support.events.AbstractWebDriverEventListener;

import java.io.File;

/**
 * Plik stworzony przez prashanth_sams, dnia 18/09/14.
 */
public class Listeners extends AbstractWebDriverEventListener {
    // public class Listeners implements WebDriverEventListener {
    private By finalFindBy;
    private WebElement lastElement;
    private String actualValue;
    private String modifiedValue;

    /** NAWIGACJA URL | navigate(), get() **/

    // Wyświetla URL przed przejściem do podanego adresu URL
    @Override
    public void beforeNavigateTo(String url, WebDriver driver) {
        System.out.println("Adres przed przejściem do adresu : " + url + ", to : " + driver.getCurrentUrl());
    }

    // Wyświetla aktualny adres URL po przejściu do podanego adresu URL
    @Override
    public void afterNavigateTo(String url, WebDriver driver) {
        System.out.println("Adres po przejściu do adresu: " + url + ", to: " + driver.getCurrentUrl());
    }

    // Wyświetla URL przed przejściem wstecz w historii "navigate().back()"
    @Override
    public void beforeNavigateBack(WebDriver driver) {
        System.out.println("Adres przed przejściem wstecz to " + driver.getCurrentUrl());
    }

    // Wyświetla aktualny URL po przejściu wstecz z poprzedniego URL
    @Override
    public void afterNavigateBack(WebDriver driver) {
        System.out.println("Po powrocie aktualny adres to " + driver.getCurrentUrl());
    }

    // Wyświetla adres URL przed przejściem w przód w historii "navigate().forward()"
    @Override
    public void beforeNavigateForward(WebDriver driver) {
        System.out.println("Adres przed przejściem w przód to " + driver.getCurrentUrl());
    }

    // Wyświetla aktualny adres po przejściu w przód w historii "navigate().forward()"
    @Override
    public void afterNavigateForward(WebDriver driver) {
        System.out.println("Po przejściu w przód aktualny adres to " + driver.getCurrentUrl());
    }

    /** LOKALIZOWANIE ELEMENTÓW | findElement(), findElements() **/

    // Wywoływana przed znalezieniem elementu(-ów)
    @Override
    public void beforeFindBy(By by, WebElement element, WebDriver driver) {
        finalFindBy = by;
        System.out.println("Próba znalezienia: '" + finalFindBy + "'.");
        System.out.println("Próba znalezienia: " + by.toString()); // Ta metoda jest opcjonalna lub alternatywna
    }

    // Wywoływana po znalezieniu elementu(-ów)
    @Override
    public void afterFindBy(By by, WebElement element, WebDriver driver) {
        finalFindBy = by;
        System.out.println("Znaleziono: '" + finalFindBy + "'.");
        System.out.println("Znaleziono: " + by.toString() + "'."); // Ta metoda jest opcjonalna lub alternatywna
    }

    /** KLIKNIĘCIA | click() **/

    // Wywoływana przed kliknięciem elementu
    @Override
    public void beforeClickOn(WebElement element, WebDriver driver) {
        System.out.println("Trying to click: '" + element + "'");

        // Eksponowanie elementów przed ich kliknięciem 
        for (int i = 0; i < 1; i++) {
            JavascriptExecutor js = (JavascriptExecutor) driver;
            js.executeScript(
                    "arguments[0].setAttribute('style', arguments[1]);",
                    element, "color: black; border: 3px solid black;");
        }
    }

    // Wywoływana po kliknięciu elementu
    @Override
    public void afterClickOn(WebElement element, WebDriver driver) {
        System.out.println("Kliknięto element: '" + element + "'");
    }

    /** ZMIANA WARTOŚCI | clear(), sendKeys() **/

    // Przed zmodyfikowaniem wartości
    @Override
    public void beforeChangeValueOf(WebElement element, WebDriver driver) {
        actualValue = element.getText();

        if (actualValue.isEmpty()) {
            actualValue = element.getAttribute("value");
        }
        System.out.println("Istniejąca wartość to: " + actualValue);
    }

    // Po modyfikacji wartości
    @Override
    public void afterChangeValueOf(WebElement element, WebDriver driver) {
        modifiedValue = "";
        try {
            modifiedValue = element.getText();
        } catch (StaleElementReferenceException e) {
            System.out.println("StaleElementReferenceException is thrown");
            return;
        }

        if (modifiedValue.isEmpty()) {
            modifiedValue = element.getAttribute("value");
        }

        System.out.println("Zmieniono wartość z '" + actualValue + "' na '" + modifiedValue + "'");
    }

    /** JAVASCRIPT | beforeScript(), afterScript()**/

    // Wywoływana przed uruchomieniem RemoteWebDriver.executeScript(java.lang.String, java.lang.Object[])
    @Override
    public void beforeScript(String script, WebDriver driver) {
        System.out.println("JavaScript zostanie zaraz wykonany");
    }

    // Wywoływana po uruchomieniu RemoteWebDriver.executeScript(java.lang.String, java.lang.Object[])
    @Override
    public void afterScript(String script, WebDriver driver) {
        System.out.println("JavaScript został wykonany");
    }

    /** DLA WYJĄTKÓW | przechwytywanie zrzutów ekranowych **/

    // Przechwycenie zrzutu ekranowego dla wyjątków występujących podczas wykonywania testu
    @Override
    public void onException(Throwable throwable, WebDriver webdriver) {
        System.out.println("Przechwycono wyjątek");
        File scrFile = ((TakesScreenshot) webdriver)
                .getScreenshotAs(OutputType.FILE);
        try {
            org.apache.commons.io.FileUtils.copyFile(scrFile, new File(
                    "/Users/prashanth_sams/Desktop/Testfailure.jpeg"));
        } catch (Exception e) {
            System.out.println("Nie można zapisać");
        }
    }
}
