package pack;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import sun.org.mozilla.javascript.internal.JavaScriptException;

import java.util.concurrent.TimeUnit;

/**
 * Plik stworzony przez prashanth_sams, dnia 09/12/14.
 */

public class OpenTab {

    private WebDriver driver;
    private String baseUrl;
    private boolean acceptNextAlert = true;
    private StringBuffer verificationErrors = new StringBuffer();

    @Before
    public void setUp() throws Exception {
        driver = new ChromeDriver();
        driver.get("https://www.bing.com");
        driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
    }

    @Test
    public void Test01() throws Exception {
        OpenNewTab("https://www.google.com");
        Thread.sleep(5000);
    }

    public void trigger(String script, WebElement element) {
        ((JavascriptExecutor) driver).executeScript(script, element);
    }

    public Object trigger(String script) {
        return ((JavascriptExecutor) driver).executeScript(script);
    }

    public void OpenNewTab(String url) {
        String script = "var d=document,a=d.createElement('a');a.target='_blank';a.href='%s';a.innerHTML='.';d.body.appendChild(a);return a";
        Object element = trigger(String.format(script, url));
        if (element instanceof WebElement) {
            WebElement anchor = (WebElement) element;
            anchor.click();
            trigger("var a=arguments[0];a.parentNode.removeChild(a);", anchor);
        } else {
            throw new JavaScriptException(element, "Nie udało się otworzyć okna", 1);
        }
    }


    @After
    public void tearDown() throws Exception {
        driver.quit();
    }
}