package com.packt.datastructuresandalg.lesson4.activity.maxsubarray;

import junit.framework.TestCase;

public class MaximumSubarrayTest extends TestCase {
    MaximumSubarray m = new MaximumSubarray();

    public void test1() {
        int[] input = {13, -3, -25, 20, -3, -16, -23, 18, 20, -7, 12, -5, -22, 15, -4, 7};
        assertTrue(m.maxSubarray(input) == 43);
    }

    public void test2() {
        int[] input = {-5, -4, -3, -2, -1, -2, -3};
        assertTrue(m.maxSubarray(input) == -1);
    }

    public void test3() {
        int[] input = {
                -13533, 3752, -591, 1988, -9113, -16361, 4108, 5630, 5000, 3944, 7512,
                -17364, 5556, -8400, 12081, -2314, 10445, -18980, -3176, -4586, 8983,
                -10502, 7701, 8010, -3982, 9037, 15054, -10557, -8021, -14963, 5976,
                -17986, -11418, -5959, -8974, -15759, 2574, 2619, 14843, -18561, -11852,
                -126, 16675, -18474, 14388, 6912, -11183, 5015, -735, -15918, -7284,
                -10146, -11920, -15784, 8154, -11555, -1257, -9391, -8401, -13924, -5428,
                -12106, 2518, 15515, -6113, -5538, 16731, 18791, -17108, 19964, -9634,
                16098, 2486, -8235, 13345, 7541, 14136, 3749, 9481, -5626, 9539,
                15569, -12504, -8825, 16462, -16503, -19940, -12911, -7052, -3818, 9490,
                -16127, -13530, 1970, -18962, 4931, -19218, 13081, 6884, -7372, -6372,
                18815, 6373, -19830, 7811, -6635, 14882, -8743, 18602, 5551, 10190,
                13387, -15113, 12175, 8900, 19245, 6381, -10371, 7970, -16913, -13100,
                2830, -6477, -13537, 9084, 10269, -12221, 609, 14793, 12507, 5146,
                -3495, 9818, 8388, -5777, -12500, 11598, 3122, -14199, -13347, -16922,
                16768, -14045, -2220, 12442, -16641, -16969, 5925, 9558, 12090, -12788,
                -16472, -15166, 14164, 18092, 17105, 15871, 15254, 17372, -18419, 18385,
                12524, -13492, 6560, -4115, 9099, -11685, -6544, -13845, 5488, 1561,
                -15308, -15215, 14313, -9821, 5478, -7439, 10441, -17594, -18858, 6644,
                -18001, -11637, -17672, 7105, -19656, -10414, -12290, -3420, -13305, 6602,
                -12271, 6943, -17277, 10247, 12033, 4827, -19937, -7599, -19878, 487,
                -14313, -10558, 13351, -3432, -14626, -15999, -1973, 7358, -3594, 15737,
                12674, 8347, -2452, -1658, 12285, 2170, -1457, -6131, 4587, 11887,
                564, -12081, 10191, 16672, -11532, -8098, -5493, 3459, -4600, 11255,
                13106, 16965, -5701, -16207, -8194, 11356, -14018, -3510, -16941, 14062,
                19866, 7335, 6809, -4062, -16012, 6584, -15618, -2433, -8649, 19422,
                16776, -2720, -2187, 19713, -17313, -10491, -8317, -3548, -5837, 16618,
                -2270, -9151, 10260, 11218, -12321, -11256, -5493, 18358, -4928, 19543,
                -11818, -16980, 12552, -19910, -19948, -9347, 5628, -18489, 12879, 7393,
                -230, 126, 14715, -4003, 10381, -13256, -3634, -1558, -17160, -14474,
                -8983, -18068, -2410, -18685, 10852, 3157, -14800, -2126, 18843, 16482,
                1627, 18365, 10749, 10490, 9927, -4330, -8257, 8703, -1517, -10955,
                -19678, -5093, 2934, -796, -3998, 7545, -5280, -11750, 4641, -6679,
                15849, 4860, 11467, 13734, 11937, -14790, 16426, -428, 1054, 17657,
                5819, -8124, -5196, 17714, -3553, 3015, 17102, 14505, -9319, -5730,
                19561, 12881, 3985, 16036, -16997, 1641, -12738, 3746, 5493, -9116,
                -3283, 244, 12018, -8097, -10603, -9464, 9519, 17609, -17579, -18369,
                -6702, -13891, 4027, 6496, 7837, 1674, 3899, -730, -7248, -5637,
                -10334, -1664, -19209, 19785, 10193, 12233, -12768, 11651, -1583, -3146,
                5822, 3917, 13820, -9348, -6089, 7463, 302, 13613, -7008, -11972,
                15774, 16570, 12549, 15146, 9948, -15739, -12018, 4057, -9469, -17626,
                -7391, -8986, -11207, -8446, 7059, -9438, 7831, -18040, -14909, -4119,
                -4260, 18874, -17490, -3354, -297, 12227, -2738, 18445, -13958, 6594,
                -15239, -6664, -14811, 16417, -3802, -3644, 1309, 11799, 19348, -6445,
                5229, 4232, -4133, 11410, 4734, -14571, 5715, 16140, -10293, 15480,
                16196, 10111, -19174, -15894, -1937, -3724, -10277, 17854, -10209, -8045,
                3530, 1789, 3532, 620, -14597, -12955, 8643, 9204, -15301, 3683,
                7887, -12200, 19525, -4322, 5442, 6977, 13118, 13400, -11224, 15126,
                15417, -1059, 16543, -212, -16814, -17151, -1945, -7336, -10649, -11272,
                -18092, 12923, 3750, -10359, 2361, -14748, -15542, -2667, -7536, 19343,
                10879, 3773, -1352, -7041, -347, -4225, -12415, 14664, -16446, -7203,
                12518, -14261, 6129, 6005, -18004, -12227, 7658, 10752, -10382, 5325,
                16705, 8143, 19387, 8273, -1819, 14022, -6080, 18942, -2483, -7182,
                -8663, 15189, -15513, 11841, 3771, 11970, -17441, -3154, -5998, 14483,
                -19251, -4438, -8925, -9914, -18223, 15855, 627, -11845, -7239, 7330,
                -4269, 16561, -2687, -15107, -2213, -16430, 19774, -3216, 5134, 4197,
                -4065, -2398, 2311, -8399, 3702, -1158, -14593, 19984, 18971, -3831,
                6904, -1535, 5394, -8117, 17462, -13838, 19735, -14337, 8610, -18255,
                -14474, -9276, -2623, -17824, 6366, 7503, -222, -14138, 4523, 2930,
                3257, -10224, -8358, 17731, 15143, 17329, 11240, 1367, -16729, 2117,
                15378, 19805, -1758, -11983, -1820, 3988, 19665, 2329, -10061, -8396,
                5456, -19786, -8519, -7258, 446, 15366, -10357, 18294, 15096, 8441,
                99, 7558, -2020, 4794, -10946, -8906, -4489, -18439, 178, 18435,
                2968, 16687, -14799, -15698, 14344, 19218, -17374, -7558, 15766, 11967,
                8274, -3601, 1011, -10383, 18028, 1030, 12927, -13466, -11997, 4835,
                2055, -6108, -19135, -18191, 3190, -11323, -6331, 8178, -13049, 9117,
                -15689, -15760, -1223, 9831, -9740, -15472, 7533, 4730, 12182, -6061,
                -15865, 15565, -11417, -9686, 1049, -19705, -3174, -3014, 2790, -19752,
                -10821, 15176, -976, -12814, -6677, 10328, 13993, 6563, -14089, -15869,
                5889, -17721, -18121, -8550, 7384, 8451, 1223, -8716, 3853, -16209,
                3595, 2110, 12370, -15700, -6566, 8908, 767, -11679, 2562, 6746,
                4230, -11092, -9653, 710, -6267, -487, 17071, -13664, -7397, -14178,
                -7934, 8024, -4072, -4677, -989, 3962, -17631, 12894, -13545, -4179,
                16043, -19046, 11803, -7135, 1461, 9330, -5035, 9192, 6458, 16865,
                -9053, -13390, -14265, -12141, -12338, 11226, 13098, 13306, -5595, 6916,
                15495, 8573, 6052, -16599, -12622, -9236, 8637, 7275, 16787, 2077,
                -5621, 670, -15763, -15395, -14694, 9802, -8609, 15848, -3450, 7793,
                3249, -14765, 9235, -17521, -7130, -4700, 16071, -11194, 16694, -6978,
                10123, -10172, 7144, 1471, 16510, 9065, -8670, 3534, -14321, -11985,
                10490, 10833, -15952, 19574, -15577, 19477, -14635, 17865, 3068, 796,
                -4391, -16894, -15985, 17334, 12091, -4122, -18153, -11306, 3132, 14396,
                -7885, -11997, -16764, -11420, 1673, 6870, -1191, 18603, 16451, 9516,
                18888, 14346, -6140, 6669, 13741, 7862, -9945, 10325, -3168, -1391,
                10967, -14937, -9758, 4535, -4579, -5940, -2422, 14318, 2672, -5465,
                12240, 4613, -18544, 6134, 13731, -6923, 19175, 10137, 1951, -1453,
                -15875, -5179, 12155, 10463, -4993, 10574, -12621, 17750, 4927, -17251,
                -17123, -11338, 6250, -8817, 19385, -16177, -15697, -15563, -3933, -14705,
                -14393, -19666, -3143, -5842, -18319, -681, 15749, -14810, -3127, -13834,
                -15277, 19545, 4846, -15586, -11175, 17083, 4766, 3947, 17362, -5867,
                -4620, -2177, -2861, 16152, 13443, 4429, -9029, -9183, 11797, 9712,
                -4599, -17924, -9882, -17777, -18107, -5471, -9677, 5369, -18033, -4787,
                4774, -1272, -16, -16807, -15984, -1411, 2726, 3669, 12606, 18570,
                2255, -12620, 11396, 19454, -19618, -18571, -18198, -7550, 14694, 4075,
                4369, 1183, -3713, 15378, -5352, -5744, -16573, -18442, -2917, 897,
                15592, -12403, 19580, 6108, 756, 1250, -19820, -15947, -1916, -12959,
                4708, -19448, -9503, -15046, 8090, 15764, -10557, 14660, -14445, -5512,
                -8926, 13415, -2882, 17264, -8905, -5134, -15348, -8703, 586, 5397,
                -807, -13405, -2727, -3266, 681, 10029, -14294, -16708, -1900, -15869,
                -13381, 8356, 13547, 16678, -17927, -1349, -9805, 11891, 14259, 19650,
                -3438, -16130, -19602, -15874, 11261, 12251, -12521, 17351, 310, 19876,
                -5783, 5757, 4142, -6183, -1337, 8100, 3339, 3348, -17616, 12330,
                -19810, -12998, 8525, 10245, 16670, -18912, 13076, 9013, -4101, 14735,
                -16806, 15157, 239, -16532, 5366, -4839, 12503, -14982, 11310, -18932,
                -1791, 13178, 17894, 19602, -3193, -16409, 5719, 871, -17856, 14841,
                12469, -5544, 1020, -14337, 15987, -9194, 6542, 10964, -1469, 3033,
                18680, 8243, 4914, 7220, -13070, 4789, 16223, 4973, -2880, 19625,
                -13654, -8209, 15115, 3194, 2771, 4597, -18115, -9229, 10132, -457,
                18473, 11507, -7331, -8121, 8194, -7894, -924, 18762, 9884, 180,
                17204, 7254, -649, -19562, -17112, 16249, 1010, 15559, 11916, 13809,
                -11637, 1950, -12444, 13720, 1464, -16854, -11520, 18479, 11964, 6261,
                -12388, -1850, 18987, -18618, 7849, -2031, -15946, -3212, -9941, -15772,
                -10785, -8683, 12412, 39, -11252, 10162, -14514, 15344, -13540, -19084,
                -16398, -6037, 2154, 7474, -6710, -3094, -19456, 5146, -18874, -15682,
                -5549, -3899, 11615, -2399, 6191, 7885, -3242, -1445, 8005, -1303,
                7487, 4913, -3886, 313, -4057, -15733, -10100, 10705, 4593, -18148,
                16284, 16990, 9877, -15756, 5723, 6962, 14389, -14890, -12658, -6415,
                2651, 5068, 10564, -5570, 14037, 3145, 14494, -6177, 13558, -8864,
                -15734, 4132, -15706, -11928, 1420, 15320, -14293, 4712, 14039, -15561,
                -8170, 8263, 12714, 13709, 9176, 18167, -7298, 5912, 13665, -1052,
                7707, -14776, -12320, -19090, -7574, 993, 3825, 17294, -14472, 9003,
                -5754, -1024, 5054, -16017, 7066, -11324, -692, -8318, -7317, -9644,
                238, -3635, -11594, -18238, -14062, 17822, -4809, -19432, -14083, 7971,
                6415, -6497, -1652, -8101, -2168, -18634, -14092, -4106, -939, -8078,
                13087, -14748, 7864, -1687, -953, -10758, 9781, 7293, 16743, 12143,
                3646, 729, 5010, 13274, 14478, 6827, -18501, 10502, -18654, -3098,
                15821, -6418, 1947, 13213, -12788, -12640, -16565, 2712, 16563, 17826,
                -15867, -12532, 1069, -3202, -3027, -18691, -15975, -5141, 17830, -1956,
                4185, -1347, 19026, 2756, -5875, 1097, 9299, 166, 10159, 14520,
                -6372, -6494, -91, 4112, -14973, 3567, -11351, 11206, -12898, -11611,
                -14079, -12106, -11458, -1905, -9837, 1715, -4484, -15472, -5547, -1291,
                13351, 4875, -5448, 11842, 8586, -11979, 19334, -435, 19232, -8824,
                5198, 19307, 4433, 9292, -2824, 9903, -5044, 16808, -14351, 9706,
                14101, 18505, 8022, 12312, 5037, -18535, 6903, 4568, -2440, 3973,
                2535, -815, 4992, -1662, -19341, -14028, 9303, -6302, -18350, 1994,
                16553, -16504, 11385, -7124, -2935, -3576, 16196, -19433, -19449, -19045,
                11489, -186, 17218, 6390, -13533, 8741, -8210, -4755, 6904, 2046,
                -17897, 14040, -10717, 154, -6529, -2632, 10757, -9472, -2780, 9540,
                4013, 13810, 12990, -7475, 4718, 13589, 1557, 15232, -10379, 17847,
                -4869, 3473, 11020, 9950, -4948, -10377, -3959, 15559, -4173, -13673,
                19432, -13803, 8375, 7847, 19120, -11197, -7427, -19404, -5599, -14932,
                -8408, 9104, 2685, 17417, -15564, -11806, -17463, 14935, 13543, -3042,
                11868, -12667, -6192, -8231, 10158, 9449, -17242, -15237, 430, 3616,
                17230, 6779, 15995, 3859, 15772, 19625, -243, -17199, 11500, 911,
                18913, 11099, 12723, -8421, -5730, 4793, -16640, -710, 3319, -12672,
                18276, -8571, -4275, -10307, 9447, 7406, -11018, 4925, 6566, -10074,
                -4462, 12098, -517, -15576, 8568, 15694, 8250, -14097, -5387, 727,
                10404, 11904, 886, -2273, -15472, 703, -1826, 4443, -4298, 12901,
                8690, 15072, -3174, -17874, -831, 6999, -5142, 14549, 13757, 16007,
                13915, -5434, 18456, 15240, 312, -14465, 17281, -10092, 476, 11352,
                16576, -11646, 14476, -10872, 4863, 8481, 11438, -12579, -2075, -15624,
                3512, 16244, -18000, 11100, -10349, -4446, 10086, -19263, -19984, 2526,
                1132, -4482, 4287, 7146, 13404, -8122, 7818, -6210, 12665, 12342,
                -12964, 14542, 10294, -13265, -1381, -19732, 5855, -5979, -17771, -8749,
                -15842, -10803, -11860, 17094, 15731, -1036, -3686, 13033, 135, 10411,
                -4409, -17379, -8399, -15564, -11359, -11963, 16982, -7026, -18280, 540,
                18166, -18848, -2762, 890, -4073, -9006, -11889, -14960, 5013, 9317,
                -11119, 10435, 8546, 5945, -2852, 16932, 416, -2028, -16186, -14582,
                10203, 8238, -17164, 7813, 16406, -2809, -13244, 2149, 8503, -8108,
                14970, 9956, -8279, -11332, 6462, -5436, 12013, -7818, 7576, -8739,
                3045, 13220, -12971, -2311, 9866, -14333, 955, -3245, 3206, 13329,
                -448, -1844, -6534, 5206, 6159, 12565, -15411, -1701, -6159, -16305,
                15817, 19463, 14646, -14212, -5220, 4008, 3858, -9853, 16185, -15072,
                9835, -11659, -6162, 1760, -18786, -1035, 6803, 3769, -13256, 2939,
                3305, -2832, -299, -2503, 5542, -16904, -9298, 4012, 10559, 2443,
                15714, -13609, 8646, -8716, -3704, -8927, -1289, -6137, -14904, 18372,
                12921, -18747, 8249, -1360, -19599, -2089, 3422, 18524, 10799, -17493,
                -10235, -5202, -17266, -13691, 12446, 5669, 2342, -42, -2597, 14412,
                -8644, 18720, -7659, -10098, 3388, -17484, -750, -3220, -7957, 2032,
                -19419, -355, -9898, 9771, -15546, 19814, -16095, -19628, -4362, -19877,
                -4756, -16405, -4261, -3514, 546, 19450, 18587, 5836, -8663, -3263,
                4875, -9958, 18030, -11173, -11001, 18636, 4398, 3971, 7701, -2336,
                12749, -1837, 3569, -10016, -10204, 19729, 1018, 9474, -4315, 514,
                -14277, -1482, 18733, 17611, 7259, 8992, -9643, 14645, 2906, 480,
                10825, -18710, -12280, 14992, -12813, -15012, -125, 18427, -8920, -4251,
                15628, -7360, -11004, 6646, -13774, -16985, 1194, 18575, -2250, -13284,
                19055, 7438, 9967, -6812, 12376, 15122, -12326, -1774, 19013, -11642,
                11072, 10274, 9697, -10787, -9893, -13961, 5474, -18287, -14863, -2167,
                8698, 10711, 18948, -10844, 8457, -6217, -13022, -13457, -2770, 16905,
                -13219, -14450, -11968, 19539, -15772, -10528, -19893, -1267, 16365, 14102,
                -1359, -14434, 11294, 9350, -10424, 14201, 13579, 2773, 7760, 15392,
                10453, -4966, 16504, 2604, 16997, 2803, -13173, 14212, -18627, 9168,
                17198, 2353, -5294, 18368, -15012, 17003, 7282, 2866, 14568, -4303,
                -16140, -2688, -4655, -11484, 4053, 15728, 16683, 4143, -4975, 15297,
                19988, -12897, -17007, -6333, 17635, 16075, 9854, 4518, 12477, 6817,
                18764, 17283, 6330, -11615, -19641, -12430, 755, 2435, -7684, 13963,
                -7013, 5248, 17945, 18166, 7898, 17582, 4688, 11205, -86, -1101,
                3718, -11875, 13857, -14061, -6116, -5115, -12507, -5825, -14169, -235,
                -19458, -11466, -84, 18812, 2340, -15824, 7136, 6617, 12607, 3564,
                -4613, -12584, -13843, -13275, -5170, 2836, -532, 5358, 10900, -17464,
                5677, 3450, -10174, -6033, -8032, 8988, 11169, 10352, 9306, -5401,
                -13128, 6220, 12080, -18592, -9847, 3607, 10310, -9813, 18432, 19749,
                -13321, -5053, -5990, 9054, -5617, 679, -13413, -15897, 16516, -550,
                -648, 3426, -1879, -17098, 14761, 720, 13761, 7316, 16185, 4178,
                14900, 18009, 12858, -9883, 18231, 19845, -2776, -15307, -11091, 7865,
                1396, -18490, 9228, 19190, 3433, -3314, 8558, 3986, 13276, -17605,
                2423, -13361, -6952, 11013, -9520, -12486, 89, 4877, -3345, 17836,
                -14358, 1385, -5280, 16870, -9737, 5393, -17809, -14508, 15134, -2168,
                -14749, 12645, -625, -14017, 8032, 16176, -694, 1265, 11877, -1376,
                -1377, 1470, 9514, 10279, -12776, -10085, -15410, -3859, 5399, 12080,
                1825, 2808, -9741, -16788, -9001, -9777, -8800, 6339, 11552, 10430,
                -18680, 3360, -9726, -14151, 17849, -5992, -18215, 8437, 6924, 7074,
                -11475, 6351, -450, 17766, 4145, -15259, 6503, 7718, 11622, 19671,
                -8999, -18066, -8413, 17340, 1366, -6946, 19622, -19797, -9899, -3555,
                15046, 17827, -5300, 680, 1611, 13987, 6054, -18934, 17605, -14782,
                -14553, -7006, 5184, 2829, 8828, -9818, 1356, -13327, 14967, 15643,
                14650, 13598, -9459, 8610, -1397, 1211, 6462, -13368, 13924, -2859,
                -7958, 11087, -12462, -19312, 14795, 664, -15404, 6857, -2218, 375,
                -15319, 1620, -15267, 9742, 16858, 14380, -9533, 13420, 6078, -10543,
                7546, 10467, 8426, 15815, -5521, 8065, -9857, 17811, 14548, -13900,
                3178, 2764, -16817, -10226, 4431, -9832, 17724, -7441, 17418, 17542,
                15605, 12403, -5513, 17544, -3059, 3606, 13344, -19837, -11345, -4825,
                -2840, 7131, -19543, 6047, 11737, -4437, -16647, -14941, 17753, -9561,
                5655, 3998, -2986, 1319, -9630, 8854, 17466, 16618, -12562, 5063,
                -4136, -17528, -19347, 9186, 14921, 652, 15835, 10477, 9793, 17180,
                -1986, 8384, 16795, 13163, 11240, 699, 3705, -16005, -2474, 9815,
                -11683, -15892, -11477, 14229, -10039, -672, 19407, 13862, -12037, -7615,
                -14501, -13420, 9740, -2804, 5124, 10318, -14231, 8534, -1101, -5178,
                -15681, -15876, 3431, -5675, 11779, -5014, -10307, -15837, -13915, -7123,
                11816, 16514, -13724, -9879, 12529, 16654, 18972, 19505, 18290, -9639,
                -15249, -12202, 3417, 11748, 9567, 7900, 18638, -16259, -111, -7025,
                -7173, 14970, -13716, -6149, -4941, 8151, -5095, 7706, -4874, -2885,
                -13568, -18593, 19044, 832, -14845, -16024, 17763, 18971, 2035, 7609,
                18655, 4585, 15123, -15575, -4024, 12026, -11945, 2016, -13605, -11237,
                -5825, 8938, 13567, -12185, 14241, -18154, 4312, 5229, 19462, -14509,
                -2375, -4604, -13524, -8710, -7560, -17230, -4310, -14511, 1048, 12333,
                3507, 6825, -13624, 5392, 3165, -13545, -312, 411, 11447, 18685,
                -5808, 15083, 6931, 19427, 4044, 308, -4213, -6271, 8841, -14874,
                13453, 17274, 8048, -3014, 1315, -15867, 11108, -7011, 17666, -1303,
                -5170, 3306, -17098, 7500, 17198, -3271, 19783, -19002, 18039, -8349,
                -8369, -3180, 15309, -3076, -13619, -7066, 11673, 18957, -12891, -15350,
                12156, 14246, -17591, -3763, 3478, -14048, 16535, 3449, 621, 14407,
                13830, -13335, 4326, -16056, 14374, -4378, -11568, 7270, -3794, 308,
                5355, 1846, -17817, 9072, 19492, 7314, -4761, -14223, 2920, -15958,
                -15783, -9436, -2178, -12811, -11251, 9027, -6192, -12919, -279, -8057,
                -3791, -2143, 17217, -5945, 9821, 2792, 8787, -2216, -10265, 15724,
                -14133, -17896, 6118, -9590, -9598, 6562, -13991, -3004, -6515, 8513,
                16967, -8995, 16106, 10961, -8950, 1405, 11401, -7412, -8359, 18293,
                10547, -17707, 6894, -1787, 12718, -3585, -8955, 9906, 18963, 10964,
                -19198, 1749, 15416, -10305, 14407, 19033, 5519, -5268, 12292, 12091,
                14786, 3998, -8613, 16846, -15843, -9933, 4494, 10316, 5606, -5117,
                19120, -18681, 1972, -5637, 16624, -16144, -7451, 4409, 7234, 17902,
                11999, 12329, -16826, -7832, 13618, 11927, 361, 18904, -2336, 15126,
                -17440, 10242, -12798, -13724, 13322, 5381, -15428, -16250, -17953, 378,
                6902, -6984, 4847, 5413, 4593, 9658, 13704, -13391, -6052, 9329,
                -18617, 1587, -1643, -13628, -9882, -13672, -16104, -3078, 4234, 4378,
                4908, -6402, 8238, 6561, -5913, 7683, 534, -14784, -13086, -13908,
                -5975, -7072, 4710, 16019, -9188, 19824, -12717, 7910, -19853, 9267,
                -14665, 15789, -17462, -5922, 17823, 6277, -8205, -12932, -14791, -16273,
                19053, -7948, 16562, -17538, -786, 8299, 13446, 10236, -14775, 10006,
                -667, 2298, -4348, -1587, -4046, 4302, 15747, -16077, 16540, -19657,
                -1785, 5377, 17174, -12676, -8529, 5148, -5147, -7613, -7577, 15353,
                2758, 16436, 6187, -13687, 15094, -9975, 11350, -12678, -10632, -12534,
                1769, 6461, -9623, -15234, -11040, -8707, 15275, -10122, 931, 11879,
                18158, 15712, -10578, -8567, 15571, -19685, -15279, -17856, -12048, -443,
                16306, -1482, -14795, 8417, 5184, 17229, -17552, 6409, -8025, -300,
                -3504, -13638, -19413, 14904, -18211, -9923, 5122, 5913, 14475, -18294,
                -18795, 4703, 1259, 8135, 12190, 1660, 7005, -527, 1580, -7901,
                -15666, -10402, -1583, -4049, 5653, -495, 18069, -11850, -9157, 9114,
                -19619, -6655, 932, 11404, 17235, -6115, -10150, -2819, -881, 13989,
                -498, -12931, 6067, -14105, 6399, 18577, -10764, -15072, 11680, -14562,
                -5396, 7880, -6463, 4640, -4717, -16453, -19928, -6910, -8881, -6264,
                2498, 3297, -6233, 16900, 17433, 12293, -15197, 10916, 18196, 11043,
                9071, -17080, 19759, -13421, -7847, 13685, -19181, -425, 5523, 11470,
                1701, 11127, 10670, -6845, -2733, 9226, -5561, 8840, 11328, -7899,
                5813, 6821, 245, -6227, -17235, -2424, 12623, -9127, -2918, 9443,
                -7057, 547, 12957, -15876, -12410, -13220, 3522, -16966, -7719, -7493,
                18935, -18020, -3004, -16264, 19711, -18648, 13116, -11828, -739, 3891,
                -4582, -17202, -8133, -15499, 16716, -3118, -14982, -14069, 11467, 15136,
                -14311, -19515, -15268, 3413, 3257, 1250, -7921, 13525, -4923, -4141,
                1019, -19261, 10174, -11065, 10531, -9762, -17169, 2032, -4572, -18942,
                -7105, -16422, 10976, -12642, -12044, -181, 19473, -15780, 9260, 8481,
                -9677, -19571, -8520, 18169, -3717, 14805, 2188, -11312, -17775, -15694,
                -8845, 11363, 12694, 5401, 2730, 12684, 987, -1046, -1193, -7754,
                8820, -19238, 11552, -2210, -12804, 10003, -15819, -6979, 18432, -10703,
                -935, 12637, 7789, -19493, -6574, -14373, -16040, -8300, -19942, 15622,
                15458, 11918, 17167, 14800, -6781, 13992, -16820, 19756, -5673, -19781,
                -9600, 16825, 339, -19018, -9095, 8430, -13792, 1016, -11554, 11366,
                10108, -4179, 8318, -2640, -15303, 5595, -12249, -2505, -9198, 6826,
                5428, -10763, -16679, 1316, -10012, 4513, -7680, 19754, 18994, -19455,
                15791, 3246, -1376, 1470, -3947, 9907, 17101, -13636, -11000, -10215,
                201, -7455, 11108, -5227, 10616, -4458, -9729, 16278, -625, -11211,
                -15808, -15405, 16310, 17471, 332, -9817, 10234, 17193, -17280, -9002,
                5473, 8118, -11417, -17792, 16979, -12591, 5958, -12316, -15378, -12493,
                9954, 8517, 2052, -17846, -1662, -1238, -1203, -19648, 13775, 6463,
                -16583, -4634, -16151, -9505, 272, -17661, -6873, 3978, 12941, 7417,
                18959, 17245, 4533, -1751, 14191, -1199, -15037, 13348, 19774, -19741,
                -184, -8571, -10980, -17229, 18115, 11780, -14424, -8786, 12781, 8032,
                5500, 3939, 13562, 17546, 16484, -17460, -15227, -16789, 9848, -2327,
                4190, 14408, -6924, -16978, 8174, -13475, 5571, -1473, 14813, -4753,
                -17815, 2317, -3654, -12776, -7233, 16311, -8362, -9018, 16967, -1776,
                146, -2603, 17608, 19167, 5959, -4339, 11698, -8173, -19833, -3182,
                -5747, -19946, -15069, -290, 9548, 3150, -10309, 3285, -12940, 15476,
                -6324, -2226, -18173, -5357, 6863, -7940, -7994, 8706, 2464, -12982,
                -2111, 4708, -7075, -14863, 6955, 9967, 17569, 17562, 8800, 4232,
                17016, -5688, -12674, 6452, -19774, 15076, 10023, -9741, 1312, -8425,
                1238, -10716, -14219, 14619, -2324, 7216, 6524, -9105, -5340, -17670,
                -2704, 758, -17829, -10926, -14404, 303, 19435, 13764, 7052, -10461,
                -14869, -7827, 19904, 974, -1278, 17095, 9466, 6832, 13709, 13292,
                7292, -1196, -17270, -1889, 4340, 17373, 14704, -14159, 14280, 13861,
                -11471, 10512, -14522, -16228, 16110, 14628, 13937, -11722, -4194, 18384,
                -3670, 5004, -987, -3176, -13932, 731, 14558, 8956, -3601, -13115,
                7263, 2623, 5675, -13930, 1682, 6637, -18189, -360, -18447, 13842,
                5697, -8145, 4351, -6773, 13541, -18035, 6443, -12986, -12595, -3014,
                -17873, 14160, -5194, -187, 14300, -11329, -7722, 11972, -7813, 1671,
                -9157, 15101, -7725, -15821, 14801, -3965, -6170, -17832, -17703, -1565,
                -9532, 2574, 12631, 3312, 5476, 5011, 13798, 4920, 6476, -14628,
                -16064, 17618, -167, 10972, -2894, -2158, -2595, 3424, 213, -17988,
                -4631, 2169, -2920, -4928, -17819, 2732, 18418, 1360, 592, 19694,
                -16879, -15395, 7218, 6506, -19550, 3515, -7819, -18004, 13050, 5231,
                -8279, 11336, 10512, -12348, -12845, -13307, 5485, -7534, 1733, -361,
                7355, 7701, -7905, 17977, -2469, -12160, 18182, -1126, 13908, -11364,
                -7188, -19890, -16878, 3360, 12666, -12666, -11097, -19009, -14536, -14429,
                15746, -6274, -16682, -12827, 11409, 11711, 2026, 4773, -3909, 11606,
                11500, 8640, -15620, 12067, 15495, 2242, -6021, 4444, 16637, 2883,
                18021, 14017, 7701, -16769, 12961, 17718, 5410, 4415, -4897, 16080,
                9944, -11962, 17122, -8951, 2403, -14049, -5318, 6047, 3320, 19089,
                235, -8958, 4195, -8129, 16514, 13130, 3172, 11157, 14096, -5036,
                382, 2226, 7747, 15745, 17011, -3684, -1712, -1167, -5056, 10143,
                -10515, -298, 17171, 1676, -17150, 10405, 17997, 4300, 19049, 16415,
                -10555, -13555, -9822, 10359, 15849, -19723, 12393, -5742, -2911, 14549,
                -10206, -18550, 12483, 9907, 3887, 14709, -15153, -1783, -14889, 13723,
                16575, 654, 15884, 6852, 8654, 11238, -14173, 5813, 18064, -7750,
                -5986, -4467, -18515, 14750, -10849, -2068, 9001, -8165, 1939, 6041,
                -12137, 10878, 12737, 13574, 10369, -4046, 7931, 16528, 13178, -15298,
                -4681, -16904, -8152, 18240, -8994, -17714, -16946, 316, 18017, 18075,
                -18699, 10647, 19721, 18181, -2774, -18582, -14427, 19052, 10350, -15243,
                -8912, -10385, -8284, -531, -13322, -10870, -3280, 11223, -14115, 10517,
                19547, 18623, 7359, 14480, 13865, -2782, -530, 9377, -16388, 12302,
                -2569, -11985, -19640, 19567, 6125, 14915, 1845, -17731, 12529, -17951,
                -11593, 650, 5967, -9654, 13784, 4977, -9460, -12050, 19431, -4853,
                -3126, -10862, 6879, 7274, 11898, -8071, -1078, -16777, 11789, -5181,
                10240, 13256, -15749, 16608, 18442, 7831, -10673, -2087, -12297, 7788,
                -11401, -9213, 14285, 17333, -12935, 17690, -7994, -8293, 4526, 15013,
                8807, 2784, -13499, -3416, 4169, -742, 9441, 4084, 10596, -16270,
                17063, -6943, -17445, -13456, 2524, 4255, -10948, 8578, -12227, 1287,
                11750, 9737, -14592, -2597, -19908, -2356, 123, 17085, 3640, 17373,
                16245, 9379, 8307, -8401, 57, -13645, 5802, 10189, 12836, 8927,
                4771, -8354, 16954, -9490, -17237, -9738, -7769, -5322, 2222, -14674,
                10808, 18195, -18308, 15125, 15722, -5985, 10366, 1651, -5027, -2090,
                -1486, 18837, 9850, 6339, 7066, -19967, 2500, -13920, -5139, 18140,
                -6311, -9497, 8082, -7532, -16798, -10136, -13332, -1191, 3003, -4441,
                -18435, 17788, 18974, -4887, -11686, 15521, -17964, -16437, 3833, 1950,
                2470, 520, -7297, 10844, -7635, 19458, -16320, 17708, 18961, 5611,
                15996, 1657, -8811, 7278, -19782, -4980, -19092, -9731, -11733, 8799,
                6270, -7934, -3862, 7523, -9787, 9836, -12082, -2316, 1476, -11467,
                17977, 13345, -15028, 1635, -2821, 2640, 18805, -12614, 1425, -18466,
                7879, 14516, -18065, 10418, -9638, 9168, 9587, -2796, -13925, 17662,
                -6271, 17129, -10250, 7335, 2112, -6831, 5859, 16543, 3837, 7009,
                -397, 2613, 6688, -15953, -11772, -8562, 656, -8247, -18948, 5918,
                -15576, -12128, -11165, 19577, -12450, 17182, -7536, -13398, 12994, 6439,
                -5255, 2016, 15734, 2462, 4720, -2608, 10549, 2656, 7449, 10059,
                804, 13394, 7550, -1745, -11361, -9765, 17564, -13058, -8849, 13823,
                5756, -7542, 8034, 7052, -3826, -2239, 7297, 14253, -15285, -123,
                -4317, -15618, 5029, 2283, 2810, 2623, -13527, -3852, 16181, 13184,
                19697, -17747, -1070, -6431, -2717, 18135, -8172, 17917, 7741, -2476,
                -13094, 13519, 9197, 17406, -950, 18927, 2105, 10444, -7210, 8471,
                8816, -1066, 9900, -13848, 17522, -8926, 15444, 9427, 13911, 16036,
                -19675, -8616, 7280, 12053, -13458, -16180, 11541, -14832, 3634, 18181,
                12170, 15834, 7214, 2328, -265, -13330, 9866, -19533, -10418, -14019,
                -9093, 4022, 18532, -13865, 10083, -18625, 5399, 11203, -2207, 2132,
                5460, 3419, 9900, -2965, 15381, -14332, 11663, 4113, -700, -16227,
                -5930, 14962, 333, -16017, 16344, -14974, -11002, -18697, 427, 9798,
                -627, -14494, -10607, -11188, 18616, -13019, -5445, 10560, 9698, -19078,
                -18226, 1865, -15038, -15764, -11492, -644, 13610, -4989, -19024, 1199,
                -6515, 14735, 17967, 3579, -12860, -8087, 10985, 12404, -9418, -7989,
                -9234, 17669, 10902, 24, 18604, 15696, -3984, -15161, -19160, -16621,
                -19290, -3077, -16186, 17367, -11781, 6076, 422, 18776, 12533, 9823,
                -12683, 6346, -1143, 18521, -12621, -9196, 4933, -17062, 18471, 13758,
                -6838, -11039, 6628, 15186, 8606, -19249, 12838, 2427, 16051, -2775,
                12051, 4625, 9294, -18890, 13301, -11918, -9105, 17939, 19915, 18198,
                -1540, -14270, 8294, 2502, -6826, -18826, -8653, -15724, -1080, 6530,
                2052, -12083, 6757, 1835, 14522, -13741, 8764, 12206, 11100, 18859,
                18094, -5413, 9116, 15528, 4430, 15829, -10707, 18057, -19126, -17587,
                15719, -10568, 15041, -1091, 4713, 13231, -16243, -6821, -18768, 7694,
                6459, 13365, 45, -8506, 3403, -2317, 8866, -13600, -18794, 7698,
                -12266, 7981, 10728, -18073, 13733, -7109, -17318, -15294, 2120, 17548,
                9796, 7162, -13553, -501, 10546, 2066, 10553, -16676, -1898, -7313,
                -13657, -14362, 16906, 4984, 15081, -13542, 3879, -13176, -19831, 12811,
                715, 8675, -9367, -19152, -13334, -8925, -15587, 1485, -9642, -6011,
                -970, -19085, 17369, -15211, -4838, 12222, -4989, 16487, -18022, -14614,
                15513, -5486, -6004, 458, 6266, -19796, 10743, 13489, -17529, -15018,
                -12973, 19648, 13248, -9119, 4365, 687, -174, 11165, 18777, 16838,
                -10378, 14082, -4347, 15721, 1079, 16349, -19340, 15411, 1179, -14591,
                -10332, 7890, -9043, -11076, -1243, 15886, 14993, -19207, 10086, 796,
                8859, 19990, -13614, -12531, -13944, -10810, 1382, 2562, -15909, 15761,
                -15231, -4046, -13390, 14574, -5322, -8312, -13543, -9980, 7615, 15769,
                17259, 18410, 8070, -16819, -7478, 15491, -13616, -2755, 2189, 13385,
                -9537, -15567, 16984, 15372, -14980, 12569, -574, 13387, 17701, 14859,
                3328, 19615, 4973, -10057, -6971, 9868, -9772, -2354, 16306, 17123,
                -10841, 10400, 184, -4131, -12536, -8559, 18812, 14667, 1361, 1968,
                -2655, -14881, 7803, -13656, -18973, -12368, -4951, 1912, -17746, -16377,
                -19272, 12125, -7036, -2623, 2592, -15818, -17307, -8194, -10111, -2457,
                -36, -9197, 4167, 6019, -10346, 6703, 639, -6199, -12435, 19389,
                875, 7860, -9614, 2112, 14401, 16778, 6052, -3888, -14074, 14198,
                -9796, -8206, -19757, 15303, 2280, 13217, 9014, -8103, 3671, -19596,
                -1197, -19614, -18560, 4823, -5093, -13155, 15614, -5872, -17680, 9130,
                -18886, 17267, -18723, 112, -17777, -16837, 5846, -11911, 9919, -18890,
                -11538, 3964, 12277, -627, -9803, 11348, -6756, -13540, -6930, -19143,
                -1193, -1443, 14008, -7120, -3920, -17527, -2387, 11854, 7329, -2698,
                -4137, 7738, 14074, -16191, -7393, 16377, 3868, -14555, 6620, 1147,
                -92, 7706, -12334, 9723, 17758, 4714, -4681, 9983, -1966, 5369,
                3267, 13983, 16699, 5532, 4246, -19348, -8348, 10899, -11924, 17198,
                7604, -4861, 200, -18121, 14469, 19729, -14452, -1627, 8832, -5796,
                12127, 1242, 8721, 12130, -9256, -5214, 11868, 16350, 16334, 8136,
                -7637, -15163, 11666, -16014, -366, -4712, 1487, 7729, -13899, -15198,
                2220, 1073, -3443, 17675, -6333, 15822, -8292, -4430, -3447, -11920,
                -76, 5611, 11857, 2352, -6246, 3479, 6717, 5028, 16476, 1918,
                6247, -4651, -7977, 9614, 9081, 6965, -17918, 9372, -2160, -14482,
                10015, 15089, 16449, 19989, 17114, -18755, -16202, -7905, 5793, -6720,
                -1705, -11153, 5714, 145, 8159, 1114, -216, -10472, 5375, 12141,
                -3395, -9645, -4856, -14829, 11299, 14821, -7505, -15192, -6061, 1625,
                -11260, 19913, -3261, 16284, 17761, 3972, 18011, -3705, 1723, 17533,
                -16787, -10181, -9559, -15555, -17660, 9021, -15553, 14143, -6221, 14960,
                16631, 1884, -3586, 2510, 18324, 6067, -13194, 14631, 772, 908,
                607, 3400, -14589, 7156, 6375, 5844, 6223, -2023, -5391, -17417,
                -13961, -8887, -5947, 9895, 13530, 12249, 9032, 151, 1512, 12825,
                16690, 4098, -13747, 6354, -2606, 12585, -3940, -3343, -17154, -15813,
                2195, -12577, -3577, 2591, -13712, 19691, 15448, 6162, -5613, 6959,
                -13016, -2783, -474, -6704, -8931, -12684, -349, 5556, 15759, 14380,
                -11193, 11685, 2776, 13061, 9752, 13894, -16061, -5417, -3446, -19923,
                3880, 13506, 3230, 14612, 19935, 8592, -15015, 9954, -12509, -16312,
                -7370, 11711, 1517, -12060, -14196, -7248, -11656, 1182, -2413, -16793,
                -466, -6965, 10544, -2534, 1123, -684, -15233, 5201, -12654, 13277,
                9690, 14370, 1677, 1959, -15613, 18263, -6433, -10202, -5708, 8668,
                11435, 15568, 1448, -2704, -3741, -10532, -12739, 1836, 19320, -3898,
                -17212, 7371, 17013, 7796, 6876, -10722, 9635, 11571, -19216, -4601,
                19035, -10461, 16858, -1612, -5149, 6242, 11390, -13185, 11994, 4765,
                -18055, -7137, 992, 12757, 7600, -10737, -5061, 19001, 6980, -19707,
                -19250, 6354, -5616, -12586, 16598, -6645, 8950, 5583, -11103, -2195,
                -12981, 11685, 13653, -19972, -11502, 18774, 17552, 10677, -528, 17438,
                7332, 19803, 13513, -15310, -1604, 481, 17968, 1869, 9561, -4955,
                17662, 14387, 10844, 5881, -13940, -95, -19994, -384, -4241, 1958,
                4262, -485, -1100, 3660, -4648, -1120, -5354, 17033, 5003, -6340,
                -19218, -7454, -13517, -10242, 8333, 8864, -11800, -7049, -12654, -12621,
                7835, 7472, -15061, 11521, 12799, 5980, -14461, -17632, 16227, -8003,
                3424, 8476, 5001, -265, -2357, 13546, 9037, -15328, 10756, -15812,
                8731, 327, 12841, 7418, -17063, 19340, 10201, -13849, -11541, 16413,
                19256, 4869, -6638, 16181, -14740, -17260, 328, 19450, -10268, -19311,
                4814, -13036, 854, -10134, -4378, -4922, 16552, 14260, 16135, -9610,
                -2762, 18486, -19016, 3, 16448, -7286, -12681, -18248, 19873, 7469,
                -15874, 5745, 15963, 14223, -915, -8574, 14952, 18350, -15595, 19002,
                16679, -2195, -16046, 6693, 4379, -6129, 18024, 9496, -16320, -9325,
                8226, -11072, -17097, -2564, 3706, -7773, 9470, 4825, -10119, 11222,
                3573, -11106, 4460, 8598, -18978, -4723, 14224, -1518, 11794, 9507,
                19389, -19190, -5048, 6520, -9014, -16891, -6123, 13788, -4167, 12376,
                11080, -19789, -16779, 5922, 1633, -7258, -4097, 15426, -11726, 11530,
                10335, 11361, -11796, 3249, 5152, -12618, -12394, 4610, -215, 7315,
                19716, -9314, 15351, 17169, 4040, 18803, -13708, 15682, -1332, -251,
                4632, 18154, 6327, 12871, 11417, -9383, -16405, 1340, 16487, -11011,
                11622, -15936, 18950, 4205, -16880, -3768, -18732, 10704, -2684, -5189,
                12231, 7494, -19100, -10082, -9215, -7345, 18587, -10192, -1507, -18140,
                -5407, 9883, -1025, 15164, -18297, 4438, -17166, -11570, 14080, 13945,
                -2291, -6767, 5491, -5468, 2939, -16077, 17487, -9231, 12203, 7807,
                -5687, -15394, -10245, 6712, 18547, 3703, 17797, 6909, 9413, 11291,
                -467, 7456, -12047, -14499, 580, 3948, -12627, -12408, -16239, 2628,
                10837, 3363, 1978, -16840, 4126, 9369, -5884, -16715, -11958, 11100,
                -7622, -11060, -14500, -14371, -2017, 5985, 10618, -13853, -3553, -10061,
                -1024, 18610, 2832, -10815, 17216, 15871, -13348, 8020, -13901, 6737,
                -7954, -1750, 11230, -18003, 4411, -11221, -11052, -16485, 9144, 15917,
                5267, -18058, -17832, 6405, 2128, 2944, 4570, 74, 14351, 17439,
                -10884, -12105, -18823, 8330, -5901, -14897, -5609, 13107, 5020, 583,
                -19429, -885, 1326, 1365, -220, 15393, -8621, -11331, 17983, 9616,
                -2310, 19686, 2989, -14016, 11678, -3235, -8189, -12825, -6302, -15484,
                -10441, -14868, 8304, -7355, 18118, 1594, 7970, -6551, -8483, 776,
                11517, -56, 4282, -7170, 3194, -19324, 2281, -33, 13972, 18444,
                14151, 15904, 10054, 19647, 18887, 2004, -8397, -4272, 942, -9445,
                19080, -349, -3455, 14058, 12294, 12024, -9950, -1559, 11326, 12738,
                353, -8057, -8039, 4586, 12102, 966, 5410, -9164, -8936, 851,
                10778, -7101, -11144, 17157, 19809, 4325, -15379, 14273, 464, 17258,
                3377, 16665, 3079, 9323, -16771, -545, 7232, -646, 11500, 19696,
                19191, 511, -7661, 17072, -891, -18723, -11863, 9512, -4881, 12518,
                -12340, 12826, -10473, -9898, 810, 2194, 18750, -6096, -10555, -18417,
                -16487, 19104, -2290, -7220, 12028, 18567, -12312, -19310, -19430, -7510,
                -5406, 3983, 3116, 5053, 18683, -13482, 16264, 14241, -17911, 16419,
                3519, -18489, -17742, 4955, -19614, -3802, -15575, -18154, 5239, -8649,
                -18451, -2021, -11493, 15888, -16921, -14887, 16194, 5150, -1075, 15669,
                -12977, 17937, 5543, -3917, -6306, -12290, -16706, -19977, -1948, 18690,
                19012, -359, 5546, -2380, 1326, 13289, -16954, -2199, 15683, 19571,
                -11732, 14305, 19229, 18450, 363, 16613, 4405, -13454, 14202, 8681,
                9722, -8695, -1296, -15903, -17101, -393, -12979, 12672, -2834, -1172,
                -14589, -18531, -14220, -7679, -16412, -11470, -592, 9198, 17877, 4118,
                -19894, 17778, -3221, -6653, 5578, 8385, -5304, -9857, 3963, 4618,
                2407, 1893, -18210, -2382, 8382, -7917, -2418, -2924, -13054, 13637,
                -243, 19000, -2374, -10209, 15821, -2084, 12800, -15229, 197, -15423,
                -18868, -4062, -5176, 5193, 3989, 8487, -14589, 13239, 3451, -15720,
                3318, -1190, 19044, 17448, 19863, -1912, -13975, 17871, -14472, -14931,
                -518, 9737, 3593, 12194, -5303, -16559, -3528, -9513, -12245, -1973,
                13225, 10430, -5256, 12789, -10280, 15911, -9374, 2820, 14127, 3214,
                2706, -5215, -1603, -17411, -15916, -192, 16185, 8934, 7107, -15465,
                13324, 1678, -13698, 19751, -3726, 17478, -4120, -4547, 5097, 17718,
                -7687, -4319, -14284, 14705, 8730, 10976, 7710, 9182, -16717, -3694,
                2118, 10535, -1678, -7753, -4375, 17211, -18994, -13250, 12179, 7762,
                15419, 12474, -14705, -2422, -4007, 10092, -19790, -1322, -19820, -3310,
                -19458, -19294, 11103, -3500, -4002, 11936, -14915, -14518, -8389, 1929,
                10312, 12117, -18803, 9604, -8339, -14638, 16405, 5937, 2027, 18657,
                1651, -19621, 4846, -13982, 16608, -1565, 13211, -4921, 2167, 7847,
                9617, 11508, 6409, -8671, -15452, 18565, -10282, -15311, 3728, 3302,
                3585, -7217, 18928, -5401, -4231, -10030, 13471, -8111, 13879, 14895,
                -19255, -11953, -14730, 440, 2419, -4140, -1945, -14999, 7015, -19816,
                -14227, -2283, 3270, -13911, -5219, -7559, -1867, 17574, -12692, 9334,
                3645, -7410, -3841, 13732, 8697, 11445, 856, 18402, 11695, -11482,
                17017, -18207, 5410, 19884, 19840, 15477, 4728, -9021, -19010, -1788,
                -7957, 13919, -1771, 16901, 6724, -12728, -4013, -10372, 5229, 2759,
                1489, -2825, -2734, -8589, 892, -13940, -5756, -7867, 4366, 14985,
                -11051, 2902, 11058, 16824, -9651, -7662, 13007, 6181, -6487, 14901,
                -6482, 17448, 6024, 10341, -16264, 1573, 6122, 14529, -13795, 17818,
                2340, -19221, -2605, -10987, 12958, -14942, -11990, 10490, 10694, -118,
                5300, 10796, 6052, 13654, -7483, 3000, 5264, -10178, -16138, -1387,
                215, 14736, 14214, 12556, -17188, -5667, -12161, -17949, -17724, 9329,
                7425, -11035, -19904, -9285, 9170, 11903, 11336, 3152, 15946, 245,
                -4336, 10723, 15861, -9324, -10707, 10108, -6676, -3004, -7910, 14572,
                4118, -13679, 2369, 14757, -12430, -2981, -11815, -7976, 11138, 5116,
                2301, -9268, 2996, -8320, 2512, 19740, -9859, 13226, -7219, -2396,
                9017, -14400, 1565, -5311, -8015, 6920, 16694, -2599, 19439, -4186,
                -19159, -13539, -17683, -6876, -1104, -7858, -7943, 2361, 11593, -12946,
                4984, 10327, 3251, 4248, -7251, 5770, -3067, 2786, 13756, 13909,
                15146, -9563, 3753, 3033, -6826, 8467, 5944, -2144, -7816, 18397,
                -18655, -3475, -14785, 17108, 1941, 129, 12797, 16913, -11248, -17832,
                8743, 18462, 8231, 18537, 7103, -8579, 2963, -14140, 14781, 6797,
                -19960, -1720, -4067, 8065, -12113, 18121, 5622, 13547, 10749, 15232,
                -10204, -3013, 15073, -12606, 18286, 13031, -11740, 6246, -13926, -16869,
                -866, -18373, -12043, -13464, -4748, 7797, 19097, -19993, -6556, 335,
                10634, 2724, 3284, 10718, -16287, -11475, 11732, -8207, 823, 8807,
                4854, -10740, 5083, -18203, -5985, -16895, 437, -517, -15754, 12368,
                -12423, 3990, 17758, 12092, -15009, -17825, 5907, 3499, -19385, -17719,
                19739, -3905, -14453, -14644, 8001, 17765, -2392, -12948, -581, -4735,
                15482, 14491, 18294, -12877, 5663, -2102, 6597, 8105, 5281, 19902,
                -5967, -19094, 9458, -1880, 4553, 4455, -3091, 14738, -5109, 4469,
                7969, -9356, 8126, -6517, -18643, -4849, 14982, -6393, 16035, -11720,
                -14053, 18045, -16204, 8589, 17041, 17240, 7686, -301, 14592, -5184,
                -7169, -9141, -17741, -124, -17713, -16567, -15440, 11855, -13219, 19203,
                -8682, 8520, 11609, -16323, 18013, 3307, 7136, -14220, 5813, 2030,
                -5395, 6719, -18868, -12194, 8331, 2129, -10041, 14221, -8500, -15685,
                -14650, 15605, -7413, -17082, -17696, 10156, 6555, 17072, -14125, 109,
                -7045, -18625, -11157, 9769, 11691, 13123, 19319, -7633, 19826, -18558,
                6874, -14642, -9716, 17518, 10899, -9882, 91, 9730, 9295, 17509,
                7026, -14395, -12566, 3882, 17500, 1341, 1262, -15042, -13853, -9149,
                12796, 11685, 12912, -3467, -1286, -8489, -9116, -2754, -16981, -16401,
                -12528, -17690, 3629, -11379, 9419, 9230, 19505, -13595, 2053, -4443,
                -735, -4267, 10759, -17651, 12055, -5160, -4241, 16809, 19206, 18950,
                4713, -5732, -2566, 10621, 4146, 12461, -1383, 9123, -10178, -15784,
                -18524, -11250, 15196, -8612, -261, 14368, 2342, -15768, 1859, -13985,
                -7015, 10660, -4307, -13914, -9429, 2195, 17323, 18262, 1057, 11195,
                6199, 10260, 12171, -2946, -1316, 16357, -11435, -9994, -8119, -18150,
                17139, -9803, 7915, 12696, 3688, 1753, -4843, 11428, 18568, -19135,
                -8905, 19584, -4045, 4488, -3328, 3312, -18699, -10714, 2488, 13486,
                14814, -6985, -16976, 11309, -16803, -18731, -14147, -6790, 14810, 17049,
                11957, -5732, 6087, -6396, -14046, -4101, 923, 12478, -12925, -5808,
                -19626, 3968, 2922, 6329, 15580, 9808, 6781, 2898, 12452, -1265,
                -11462, 1328, 16563, -18572, 1765, -5656, -18891, -11356, 19772, -15246,
                -8251, -14354, -11797, -10133, -11548, -15899, 7709, -15643, 15331, -8025,
                8683, -1101, -9592, 16175, -16277, -13577, -16035, -17489, 12608, -17257,
                -713, -7717, -10426, -6585, 19666, 6906, -11588, -11199, -12798, 8538,
                -9323, -19961, -12425, 10255, 3950, -18719, 8257, 2996, -9286, 10944,
                -9807, 4243, -15120, -4751, 2194, 17836, -8313, -10407, 6878, 12827,
                -353, 8988, -2664, 7828, -18907, 5461, 11337, 12612, -7240, 375,
                9820, 846, 19282, 7427, 18493, 1003, -14869, 16694, 11647, -3676,
                -19329, 15718, 4393, -6745, -2084, 9018, -13249, 11935, 11791, -283,
                -2251, 14599, 16291, 4766, 16437, -10977, 12255, 374, -1929, -10741,
                6952, 8052, 543, -12813, 16143, 7054, -2225, 19007, -2753, 16962,
                2189, -4806, 7311, -12182, -14440, 1772, -14592, -2908, 19251, -3135,
                7565, -11615, -4365, -15960, 6977, 11073, 4117, -5441, -3075, -17217,
                17905, -1385, -17756, 6406, -10369, -14736, 17565, 14669, -14730, -10694,
                2658, 12042, -16830, 11556, -14673, -3476, 559, 4939, 3599, 18352,
                -8863, -13351, 141, 8810, -3095, 6845, -7580, 11208, -14110, -5335,
                18819, 7956, 19962, 8960, -15211, -16010, -13670, 8589, -3008, 8423,
                7101, 11570, -13835, -18743, 13564, -12725, -11787, -16099, 15644, 5612,
                -19476, -4703, 16838, 12932, -17683, 1697, -7563, 11307, -17882, 16428,
                -11685, 10724, 12913, -16396, 4887, 1198, 15285, 17435, -13924, 6295,
                6961, 10447, 11693, 19147, -1261, 7911, 8076, -12746, 5047, -18974,
                10826, -7704, -13664, 8257, -6085, -13228, -12112, -17580, -5799, -183,
                5783, 18918, 5484, -5213, 4595, 9394, -9189, 2754, -7958, -9511,
                -3498, 8870, 8859, -15179, -19925, 16538, 1590, 8298, -9310, 2303,
                19845, 16676, 327, -8320, 8593, -4350, 13257, -14055, -6031, 17233,
                16663, 11467, -4140, 634, -18922, 87, -16507, 7302, -19989, 3317,
                11500, 11527, -11581, 2151, 2968, -9681, -5591, 14807, 14650, -16682,
                -18028, -18496, 13523, -2197, 6289, 18593, 69, -502, 13591, -6137,
                5885, -857, 6240, -12157, 17878, 8949, -9581, 8802, -6557, 10990,
                14921, -9746, -4902, 2464, -8457, 4715, -14519, -9485, -19725, 11039,
                4513, 16082, -7211, 2879, 5598, -18399, -1191, -13129, -11151, 847,
                -1300, -4287, 17293, -16476, 614, 4107, 19680, 12194, -16073, -14115,
                -7914, -4327, -5140, 9739, 18986, -3141, 14638, 16526, -16798, -17896,
                -5702, 8449, 8895, -7849, 4838, -18238, 2020, -2789, -19920, 8092,
                -2659, 4778, -4682, -9617, -8077, 16823, 14617, -10063, -10908, -732,
                -17395, -12556, 3343, 2280, 10912, 18617, 15390, -11938, 1913, 19355,
                16144, 18026, 8643, 13804, -12173, 19793, -11781, 15340, -4399, 13283,
                10141, -9298, 13595, 977, -6857, -13616, -1808, -14149, -4174, -9819,
                -4434, 9553, -4257, 17400, -278, 17635, -11239, 4657, -7876, -15492,
                -3581, -10637, -15604, 131, -16532, -14154, -15383, 14157, -6312, 3347,
                -10044, -3950, -11987, 5949, -15072, 8130, 10214, -7901, 14523, -14303,
                10332, -2544, 7718, -13333, 17693, 12393, -18017, -12286, 747, -15198,
                -14900, 12271, -4162, -11729, 6015, -17247, 16304, -10671, -3433, 986,
                13951, 15039, -18428, -18375, -15215, -3186, 8718, 18057, 14628, 12750,
                -16988, -17608, 1253, -15168, 13693, -18907, 3445, 6025, -1057, 3369,
                -3626, 19355, 7623, 5351, 11039, 14240, -6254, 12891, -15092, 150,
                -11665, -19456, 612, -6391, -19529, -9255, -370, -3726, 7912, 7269,
                4734, 19245, -5833, 12833, 13858, 16581, 6245, -17346, -14584, -11074,
                -10998, -11847, 16693, -19125, 1766, -18562, -6621, -11301, 13487, -5862,
                12847, -6888, -6224, -11586, 18054, -9013, -16167, 19337, 6727, -11766,
                14408, 8178, 13935, -14444, -4994, 9635, 599, 17174, 4499, 18639,
                -12197, -11376, -17653, -16554, -10969, 18685, -19424, 12895, 3732, 4666,
                -12969, 10195, -16228, -16434, 5589, 9248, 6092, 11741, 9291, -2944,
                7529, 19810, -8312, 9816, 18983, 14143, 18703, 15739, 1145, 7474,
                -14535, -18080, -18724, -6523, -8681, -17280, -8118, 17882, 8884, -8770,
                -7278, -3687, 1962, 10578, 10620, -5081, -9671, 11880, -8705, -9243,
                4570, 12376, -221, 7190, 12121, -7326, 921, 823, 14003, 9443,
                8377, 256, 15126, 9540, -12157, -340, 201, 2195, -10881, -305,
                -13924, -16414, -18276, 7959, -4448, 2608, -419, 5702, 4791, 11765,
                16769, 17709, 4789, -7566, -8600, -10859, 18270, 3486, 10815, 1925,
                1779, 14482, 5592, 14933, 8149, -10582, -18937, -12354, -17034, 15523,
                12023, -10672, 13179, -8056, 8966, -14804, 16052, 5605, -11872, 14342,
                -6311, -2168, 8027, 14457, -14237, 6881, -2686, -8177, -6619, -5084,
                -13760, -13333, 18530, 18682, 11480, 10324, 13462, -19079, -1458, -14310,
                18868, -15961, -13837, 6705, -563, 7732, -1152, 19620, -6339, 14517,
                -643, 7139, 19185, -4712, 10786, 7067, 2531, 4103, 16390, 7376,
                -18554, 8552, -3359, -12997, -9743, -8931, -18475, -1600, 5465, 1631,
                -18469, 13420, 9995, 13085, -3252, -7228, -6539, 14034, -7848, -576,
                16111, -5178, 3856, 179, -1343, 4551, -3923, -509, -16251, 2803,
                -1662, -14830, -15454, -3865, 11250, -2591, 14912, -977, -18332, 2424,
                -1646, -8269, -17586, -17981, 14977, -346, 11283, 3779, 6748, 13422,
                -17780, 12666, 2383, -18793, -13210, 6849, 17324, -10097, -15931, -19079,
                19851, -5448, 19749, -14219, 1536, 6111, 17996, -13943, 11620, 16596,
                -1134, 16554, -4249, 4375, -2516, -16204, 1719, 16554, 1423, -17098,
                -2836, -6659, -16223, 9905, -1557, 13792, -17611, 7646, -10266, 12738,
                -18295, -6837, -5580, -13126, -12178, -16414, 17376, 7324, 2382, 19242,
                8975, -19849, -7603, -18500, 3318, -8580, 1559, 18968, 5230, -12893,
                -19059, 411, 5419, -7686, 10264, -19055, -17092, -19941, 10605, 7033,
                3150, 13481, 19864, 12954, 8718, -14748, -16347, 15246, -4492, -4714,
                13551, 9492, -1400, 19506, -5608, 19452, 12003, -11172, 8540, -10846,
                2037, 4659, 18653, 1422, 2590, 17099, -3935, -4188, 4581, 13175,
                11238, 9753, -7132, -1701, 17000, -4790, -3153, -8531, 1733, -13786,
                -14540, -7114, 12425, -15104, -16757, 1186, 11034, -15705, 18306, 18314,
                -1752, -13705, 12699, -2484, -18868, 5437, -16308, -7071, -10020, 1471,
                6604, -11834, 17576, -445, -4645, 2403, 4679, -17253, -6157, 17095,
                3161, 13322, -9782, 16282, 14939, -3993, 11495, -2312, -5563, 15826,
                -1424, -16911, -14970, 9486, -13085, -2183, 2265, 15891, -5026, -8326,
                -16010, -3088, -7074, -12066, -8496, -9413, 4619, 19826, 18417, -15526,
                -7793, -18485, -19691, -7198, -11939, 4969, -9585, -2287, -9207, -2726,
                7314, -11358, -11519, -19571, 2723, -439, -7303, 13995, 5397, -12799,
                -4901, -77, -2008, -5799, 15214, 7985, -1262, 6136, 11270, 811,
                -16028, 14625, 6526, 231, -70, 17854, 8620, -10033, 3393, -7042,
                870, 19800, -442, -10000, 17449, 447, 5594, -8313, -11425, -8396,
                10935, -7146, -12393, 9147, 2855, 10163, 17761, 1899, -6622, -2201,
                -16465, 14661, 5170, -2558, 10550, 10496, -19101, -11545, -12908, 1605,
                13798, 13977, -17387, -8013, 1015, 17184, 4612, 13187, -7801, -17665,
                14628, 3136, -1590, -19571, -1290, 14749, -8803, 15213, -17584, -8645,
                8585, 9981, -15049, -18468, -18262, -18067, 5079, 18016, -186, -14374,
                -10076, 18874, 633, 9643, -6887, 10213, -13986, -18801, 8277, 18266,
                15376, -16575, -4321, 6410, 7194, -18199, 15105, -12178, -15631, -11973,
                10460, -7895, 3030, -11397, -3238, -5745, 13129, 4039, -9243, -12051,
                -15714, 19750, 13399, 6993, 15464, -4753, -4258, -15779, 15257, -82,
                -1792, -11860, -6736, -9472, -3527, 1387, 18903, 14801, 17323, 15405,
                9428, 16285, -427, -11927, -18289, 9696, -10871, 2563, 7230, -3309,
                -2974, 5072, 2688, 3431, 11192, -11316, -3802, 3858, -18586, -4022,
                -9155, 4782, 4599, 539, -44, 3898, 10901, 12570, 12242, -8897,
                -8127, 5475, -1988, 16288, 7712, -12547, 18919, -17572, 19535, 9711,
                9700, 12133, -14626, 4931, -974, 13743, -16572, -18184, 8693, 6805,
                5117, -8438, 10843, -939, -5329, -118, -6340, -4500, 17016, -5119,
                -18233, -6116, -8020, 14353, 3300, -17422, -4154, -1669, -3292, 11080,
                -14118, -545, -8182, -8544, 15528, -376, -7215, 17114, 5891, 16954,
                -9151, 7401, 14163, -8724, 1093, 262, 2060, -6376, -6753, 1431,
                12216, -10833, -7578, 17820, -748, 1495, -10240, -11105, -7504, 10435,
                6225, -2086, 1137, -2301, -8402, -7457, -14096, 13649, 11427, 13826,
                -7039, 15538, 7329, 15363, 2195, -7618, -9917, 18139, 4374, -15079,
                8839, -1128, 16333, -9101, -17047, 12390, -6761, -14168, 11133, -14878,
                16225, 14135, -4981, -1961, -6333, -2218, 5103, 1549, 15163, -17849,
                7235, 9001, 3453, 14364, -11345, 6477, 13315, 5363, -16107, -12798,
                13726, -14365, 19915, -11410, -18717, 19844, -19438, -7025, -7062, 5554,
                -2673, 12859, -13948, -9928, -8276, 5532, 10712, -19076, -13527, -7116,
                8075, 17974, -8467, 4302, 5580, -12556, 15228, 18991, -18540, 716,
                -14460, 8560, -4647, 4076, -5728, 13187, -11487, -239, -7348, 6743,
                -13116, 4073, -17222, -11495, 7425, -6406, -3937, 9491, 17756, -18304,
                -8994, -8329, 13507, -3296, -13736, -5904, -1444, 16381, 16157, -12126,
                -16554, -10704, 12986, -18554, 6370, 210, 8582, -13568, -17634, -5404,
                4136, -15328, 3761, -15240, -3179, 6743, 5073, 1442, 545, -8313,
                11754, 15090, -7539, 11015, 8384, -380, 4291, -19614, -17611, -12073,
                12819, 17511, -16889, 3361, 12800, 12576, -9135, 16806, 4358, -8112,
                -11697, -8092, -13142, -5637, -1088, 9739, 1814, 16272, -5105, 9623,
                -18013, -1205, -13340, 14888, -519, -5451, 16503, -1122, 15918, -2539,
                -8268, 16036, 3591, 15219, -4602, -12490, -10854, -9052, -12828, -8024,
                10644, 2968, -6851, -17224, 6394, -7332, 19732, -3798, 10598, -2994,
                -5064, 8800, 11677, -3428, -2014, 8200, -8250, 3341, -7828, 4955,
                -9187, -17032, -11478, 11976, -9608, -17016, -11102, -12074, -8165, -10304,
                -9327, -6616, 3765, -14782, 19101, -16379, -2921, -18422, 18432, 16956,
                6423, 3003, -2948, 8482, 264, -4021, 1991, 45, 8872, -940,
                -9995, 19868, 14233, 5608, -15741, -16583, 14903, 4862, -18238, -1596,
                -9177, 7914, -4076, 3798, 12150, -14552, -2047, 13452, 16862, -7919,
                -13971, -18105, -4363, 12789, 17906, -5632, -9197, 5886, -19835, -4819,
                5743, 17884, 14782, -15213, 4306, -8476, -4551, -10108, -11869, 18823,
                -10743, -3934, 12288, 2669, 7736, 10516, 6162, -1556, -5263, 9348,
                -14143, -14853, 2405, 2581, -4445, -7210, -2488, 18144, -15679, -7747,
                -441, 2991, 5987, -7723, -18797, -2640, 6183, -4013, -12769, 15633,
                -10240, -11256, -13032, -16371, -445, -3424, -3243, -19556, -16892, 1639,
                -19738, -1841, -10464, 3609, -19340, -17140, -17709, 15468, 17204, 4083,
                1037, 7420, -5759, 9195, -17088, -2882, 17525, 11856, -18162, -14728,
                14869, -3788, 7076, 5698, 17103, -15825, -6987, 18601, 3167, -3537,
                -2500, 676, 2473, -4399, -17185, -7843, 18934, -3437, -17700, 2041,
                16340, -10833, -9523, -1401, 1627, 17103, 981, -14420, -17538, 3781,
                9041, 7746, -15371, -3376, -14264, -15209, 17967, -1135, 9383, -4727,
                -5416, -16953, 19019, -16727, 12300, -4062, -7740, 15644, -6119, 403,
                -1316, 7565, 18744, 8975, 5710, -15079, -1591, -14900, -7320, -1308,
                2671, -553, -1506, -7003, -18317, 12924, -18285, -16866, 1693, -11166,
                -10744, -2543, 13958, 3728, -1398, 3293, 2182, 13692, 10935, 7541,
                9907, 9890, 7137, 7182, -13021, 4797, -14536, -3333, 12964, 16438,
                8656, -17259, -10285, -7664, 9831, -12139, 12898, -17721, -12757, -8620,
                16591, 3524, -4, -5015, -18964, -13376, 18029, -1485, -12880, -6428,
                -5937, -1399, 8663, 12471, -16996, -8659, -3711, -9282, -10932, -105,
                6729, -863, -5795, 5138, -3314, 8085, 14251, 12021, -12641, -9526,
                -18844, -2072, -2136, 2484, -8591, 6478, -8296, -14080, -2916, -12135,
                15218, 10231, -15651, -6396, 17225, -12259, 19552, 11628, -16437, 18907,
                -12262, -12654, 1119, -19860, -6081, -13281, -12366, 2813, -15273, 14063,
                -5286, -13578, -3087, -495, 19978, -16871, 13954, 1650, -2463, -3589,
                -6449, -15548, -14772, 4208, -11114, 3447, -13167, 8127, 5887, -9188,
                11703, -12805, 17420, 17183, 4577, -2462, -4282, -5261, 1191, -13230,
                -5486, 2024, 12709, -7940, 18221, 6114, 9353, -6566, -12692, 13211,
                9603, -10212, 1823, 7161, 17899, 4979, -11488, 15387, -9617, 13804,
                7472, 15099, -147, -16633, 4116, 2089, 17973, -13856, -14732, -11972,
                -9431, 7204, 11538, -10155, -12086, 17258, -17605, 4502, 14428, -17423,
                4121, -13759, -14027, 14322, 17000, -5463, 1277, -1048, 19471, -10339,
                -1103, -13397, -19078, 3382, -4293, 17857, -8338, -16577, -18550, 2843,
                10227, -4406, -13283, 9746, 12524, -16244, 4364, 4875, -14051, -9379,
                -10787, 16441, -15720, -1889, -7593, -14560, -5226, 3902, -5444, -2255,
                -13356, -9703, 6105, 679, -13793, -6261, 394, -1253, -5333, -16824,
                -4608, -5489, 19089, -14819, -7051, -18084, -534, -19788, 14010, -5131,
                -16719, -1893, -17634, 5040, 14819, -5325, -5905, 2100, -5307, -2087,
                -17858, -7193, -7614, 2351, -8210, 11647, 12503, -14393, -18989, 348,
                -14638, -16207, -14573, -16665, -9059, 1340, 961, 13403, 1976, -6645,
                -12137, 14834, 18629, -8333, 15007, 19669, -14774, -6999, -10826, 6217,
                -5504, -14812, -8222, 19468, -19289, 11976, -16260, 16489, -16845, 11297,
                1183, 1282, 9863, 3633, -9141, -7150, 6584, -19130, -1366, -9288,
                -3788, -5083, 18908, -320, -14401, 8118, 1956, 18820, -11891, 14587,
                5433, -12861, -11960, 13436, -1808, 12852, -4104, 7166, -7209, -5181,
                7537, -18426, 3375, 19550, 4618, 19303, 3901, -14219, 12590, -2881,
                -16269, 10141, 15443, -5166, 10684, -1504, -5038, -16591, 19965, -8777,
                -10809, -6851, -3917, -8586, 17064, -2788, -19406, -18455, -3010, -362,
                8926, -12019, -2933, -5620, 5285, 106, -10343, 1531, 16199, 16794,
                -2960, 18379, 8516, -15621, 3463, 2698, -11999, -15331, 9626, -5473,
                -15306, -13136, -2823, -1406, -17665, 6760, 11743, -4092, 10996, 18807,
                19423, -11857, 4190, -8896, -14857, 10413, -4800, 9536, -19001, -6975,
                -16983, -9276, 6286, 15329, -15557, 14039, -3376, 10024, -13931, -8030,
                15911, 302, 2974, -15586, -19568, -9055, -11381, -13707, 18836, 1473,
                3169, 3221, 17049, -15383, -19930, -8922, -15836, -16504, 1122, -18546,
                -15131, -4073, -5503, 2596, 16372, 19211, -16477, 2322, 16405, -6950,
                19443, -16093, -8867, -8990, 11507, 12963, -5314, -16145, -2924, 19061,
                -674, -12824, -13741, 16496, -11487, 9328, -2088, -5982, 15374, -13537,
                -8973, 12738, -5232, -18259, 7163, 18610, -213, 19273, -5107, -13890,
                -5825, 4222, 15088, -5568, -13592, -8173, 11951, -13072, -16690, 17268,
                11215, 1921, 2717, -4571, -12920, -5731, 2715, 4640, -8903, -7944,
                6854, 10569, 6302, 16477, -3433, -570, -17101, 19281, -17372, -19326,
                -9085, -6889, -8008, 14682, -19776, 18259, -1932, -13897, -9266, 2585,
                696, 7827, 6725, -2701, -1881, -3116, 13993, -14052, -11442, 10352,
                18244, -12514, -11991, -16687, -15156, 12569, -5901, 12421, 16660, 14529,
                4553, -12204, 19011, 1558, -19814, -19062, -6877, 17053, 9113, 14392,
                17922, 19514, 13140, 13122, -906, 13305, -19175, -6847, -1788, 15194,
                3629, -9046, 6688, 6568, -17213, -12741, 11459, 1167, -2371, -10602,
                -11019, 8295, -202, 735, 12111, 14801, 15530, 16275, 19417, -14252,
                7670, 19268, 15086, -13041, -18704, 2089, -15500, -8932, 19402, 4239,
                9513, 19009, 5844, -11548, -4239, 5962, 10416, 7050, 5406, -7181,
                -4421, -18455, -19739, -8098, -12874, 6622, -6424, 4115, -16460, 12173,
                1942, 18167, 19961, 9555, -1368, 5781, -17450, -9007, -3382, 11861,
                4340, -15254, -19172, -17458, 18785, 911, 18152, -13767, -16199, 15881,
                -15505, -29, 4652, 11591, -6264, -12142, -17908, 13050, 13641, -11733,
                -11916, 15745, -18705, 1367, -6270, 12189, 8863, -4588, 5057, -1422,
                14636, 9876, 10338, 605, 4239, 12754, -15746, -13088, -1191, 6322,
                6705, -13021, 4775, 10631, 6940, 17122, -757, -18594, 4782, 9627,
                -7659, -3917, -10700, 14654, 11449, -7961, -8422, -8335, -11423, -17117,
                -14491, -14279, -10696, -4003, -2837, 8490, -15451, 10298, -19242, -6332,
                -16301, 18183, 15700, 4728, 697, 4627, 17689, 14527, 2628, 19896,
                -15870, -12941, -19033, 1897, -16443, -5929, 973, -1350, 10361, -5310,
                3400, -6546, 19027, 18027, 4125, 18313, 17714, -1316, -10648, -5907,
                9840, -17176, 2800, 7572, -13449, -6288, -18247, -12888, 13957, 1115,
                18861, 2363, -18496, -15873, 14455, -3368, 13451, -18336, -632, 13759,
                -17885, 7861, 5793, 8888, -6203, -2897, 3587, -235, -8192, -18986,
                -1770, -11179, -160, 12051, 10911, 19197, 14398, 6435, -6649, -19568,
                16377, -17791, 11196, -15698, 5915, 11197, 12698, 11527, 11793, -11894,
                -17834, 3345, 7732, 10055, 1824, -9853, 10518, -367, 13786, -746,
                16516, -10374, -781, -6633, 18574, -11649, -7717, 162, 9268, 3063,
                -11779, -6351, 1413, 2865, -17378, 1698, -6975, 814, -5747, -13533,
                12991, 18357, -9863, 11162, 8972, 9152, 18036, 3161, 3068, 16887,
                -8017, 16046, 3199, 11112, -11949, -1651, -11951, 19822, -423, 4583,
                -17597, -11372, 9516, 5711, -17561, -15754, -7616, -6205, -15111, -19067,
                -14598, -8873, 18391, 10788, -11390, -3981, -18362, -18261, -1035, -10674,
                15968, -2064, -7678, 9523, -7792, -8630, -16197, -15921, 10292, 14592,
                7885, 6564, -14715, -13508, -9505, -9097, -3813, -16461, -15181, -6660,
                12699, -14273, 14110, -9506, 13032, 6634, 5942, 2871, 238, -7118,
                -7576, 10880, 1696, -17206, 13926, 14907, -5457, 643, -13356, -7615,
                -15205, 16072, -19948, 18867, -13406, -1166, -13283, -2519, -18167, -38,
                -6275, 11019, 11893, -11714, 7336, -16374, 16305, -3597, 5386, 2026,
                8084, 19894, 313, 11059, -13619, -17662, 5521, -9489, -9391, -19873,
                -10642, 8729, -8374, 3749, -13514, -5776, 2556, -16176, 17321, 6090,
                11806, 8546, -12581, 2457, 19479, -8245, -797, 14915, -14542, 12428,
                -3597, 1861, -4954, -11837, 6348, -16982, 3165, 7846, -19775, 10962,
                7061, 5962, -1886, 6236, 2077, -1948, 8623, 5163, -3839, 110,
                -371, -7350, 13385, 8776, 19673, -10538, -14487, 12173, -12991, -18812,
                -5142, -17512, 14848, -1223, 16525, -12345, 1870, 16591, -828, -756,
                7550, -2899, -11279, -9532, -4098, 18559, -8948, -19915, -5468, 19061,
                -3756, -1662, 7501, 401, 16318, -3122, -14064, -1808, -1559, 9390,
                19437, -15146, -19737, -2818, 15720, 11547, -7474, -18463, -596, 9690,
                15492, 5857, -1874, -14969, 14498, -16380, -11153, -7207, 2096, 3923,
                13033, -9452, -726, -15199, 7882, -17589, -3447, 15000, 15538, -5421,
                -18392, 17022, -13900, -15494, -1848, 2630, 4098, -11500, 12448};
        assertTrue(m.maxSubarray(input) == 959679);
    }
}
