package scalax.config.test


import scalax.functional.{Functor,Monad,Applicative,ApplicativeMagic}
import scalax.config.Config
import scalax.functional.Implicits._

class DataStore(connection: java.sql.Connection) {
  //
}

class WorkerPool() {}

class Application(ds: DataStore, pool: WorkerPool) {
  def doStuff = "Działaj, działaj główna aplikacjo!"
}

// Ten test pokazuje, jak skonfigurować aplikację w oparciu o monadę Config.
object Test {

  // Domyślne właściwości
  def properties = Config.propertyfile(new java.io.File("jdbc.properties"))
  // Właściwości JDBC
  def jdbcUrl = Config.environment("jdbc.url") orElse properties.map(_.getProperty("jdbc.url"))
  def jdbcUser = Config.environment("jdbc.user") orElse properties.map(_.getProperty("jdbc.user"))
  def jdbcPw = Config.environment("jdbc.pw") orElse properties.map(_.getProperty("jdbc.pw"))  
  // Lepszy przykład: konfiguracja puli połączeń
  def connection = Applicative build jdbcUrl and jdbcUser and jdbcPw apply java.sql.DriverManager.getConnection
  // Budowa podsystemów z wykorzystaniem komponentów
  def dataStore = connection map (new DataStore(_))
  def workerPool = Config(new WorkerPool)
  def system = Applicative build dataStore and workerPool apply (new Application(_,_))
  def main(args: Array[String]): Unit = {
    system.get.getOrElse(error("Błąd podczas odczytu konfiguracji dla głównego systemu")).doStuff
  }
}