import java.security._

/** Ten obiekt definiuje domniemany widok, który zamieni funkcje Scali
 * w instancje PrivilegedAction, które można wysłać do java.security.AccessController.
 */
object ScalaSecurityImplicits {
  implicit def functionToPrivilegedAction[A](func : Function0[A]) =
    new PrivilegedAction[A] {
      override def run() = func()
    }
}

/*

scala> import ScalaSecurityImplicits._
import ScalaSecurityImplicits._

scala> AccessController.doPrivileged( () =>
     | println("Ta operacja jest uprzywilejowana"))
Ta operacja jest uprzywilejowana

*/