package booleans

/**
 * Kodowanie wartości logicznych w systemie typów.
 */
sealed trait TBool {
  /**Funkcja 'if' jest konstruktorem typu.  
   * TrueType: Typ zwracany, jeśli aktualna wartość to true.   
   * FalseType: Typ zwracany, jeśli aktualna wartość to false.   
   * Up: Ograniczenie górne wszystkich wartości, mające na celu uniknięcie zbyt wielu akrobacji kompilatora.
   */
  type If[TrueType <: Up, FalseType <: Up, Up] <: Up
}

/**
 * Wartość 'true' zakodowana w systemie typów.
 */
class TTrue extends TBool {
  type If[TrueType <: Up, FalseType <: Up, Up] = TrueType
}

/**
 * Wartość 'false' zakodowana w systemie typów.
 */
class TFalse extends TBool {
  type If[TrueType <: Up, FalseType <: Up, Up] = FalseType
}