package test;

// Ten obiekt zawiera testy wiązań/zakresu omówione w rozdziale 5. 
// Inne definicje wykorzystywane w tym pliku znajdziesz w externalbindings.scala.
object Test {

  def main(arg : Array[String]) : Unit = {
    testSamePackage()
    testWildcardImport()
    testExplicitImport()
    testInlineDefinition()
  }

  // Szuka wiązania 'x' w tym samym pakiecie (test) co zakres this.
  def testSamePackage() {
     println(x)  // Wypisuje: "Zewnętrznie związany x w pakiecie test"
  }

  // Definiuje nowy zakres z wiązaniem 'x', które możemy zaimportować za pomocą symbolu wieloznacznego.  
  object Wildcard {
    def x = "Import x poprzez symbol wieloznaczny"
  }

  // Ta funkcja wypisze wartość wiązania 'x' po zaimportowaniu z obiektu Wildcard
  // za pomocą symbolu wieloznacznego.  
  def testWildcardImport() {
    import Wildcard._
    println(x)  // Wypisuje: "Import x poprzez symbol wieloznaczny"
  }

  // Definiuje inne wiązanie 'x', które możemy zaimportować w sposób jawny.  
  object Explicit {
    def x = "Jawny import x"
  }

  def testExplicitImport() {
    import Explicit.x
    import Wildcard._
    println(x)  // Wypisuje: "Jawny import x"
  }

  // Definiuje lokalne wiązanie 'x'. Zwróć uwagę na to, że przy wszystkich tych importach nie występują konflikty nazw.  
  def testInlineDefinition() {
    val x = "Lokalna definicja x"
    import Explicit.x
    import Wildcard._
    println(x)  // Wypisuje: "Lokalna definicja x"
  }
}
