package example

class PlayerSpec extends SomeSpec("PlayerService") {

  it should "powinien zostać skompilowany" in {
    """PlayerService.Player("Cristiano Ronaldo", "Portugalia", 32, "Real Madrid")""" should compile
    }

  it should "powinien zgłosić wyjątek w przypadku nieprawidłowego źródła" in {
    val src = "dowolne źródło"
assertThrows[java.io.FileNotFoundException](PlayerService.readPlayerDataFro
mSource(src))
  }

  it should "powinien zwrócić kolekcję typu String po odczytaniu danych z prawidłowego źródła" in {
    val src = "/Users/vika/Documents/LSProg/LSPWorkspace/First_Proj_Testing/src/main/scala/example/football_stats.csv"
    PlayerService.readPlayerDataFromSource(src) should not be empty
  }

  it should "powinien zwrócić None podczas przetwarzania nieprawidłowego ciągu tekstowego danych zawodnika na egzemplarz Player" in {
    val data = "nieprawidłowy ciąg tekstowy danych o zawodniku"
    PlayerService.parseToPlayer(data) shouldBe None
  }

  it should "powinien zwrócić egzemplarz Some Player podczas przetwarzania ciągu tekstowego danych zawodnika na egzemplarz Player" in {
    val data = """1,1,2,1,2,Cristiano Ronaldo,Portugalia,Real Madryt,Hiszpania,32,4829,40,4789,124,63"""
    val player = PlayerService.Player("Cristiano Ronaldo", "Portugalia", 32, "Real Madryt")
    PlayerService.parseToPlayer(data) shouldBe Some(player)
  }
}
