package chapter7

import java.util

import scala.collection.mutable.ArrayBuffer

/*class Book(val title: String) {
   val chapters = scala.collection.mutable.Set[Chapter]()

   def addChapter(chapter: Chapter) = chapters.add(chapter)

   def pages = chapters.foldLeft(0)((b, c) => b + c.noOfPages)
}*/

case class Chapter(name: String, sn: Int, noOfPages: Int)

class Book(val title: String){
  val coverType: String = "Wersja_papierowa"
  def cover(cover: String): String = coverType + "_" + cover
}

class Dictionary(name: String) extends Book(name){
  override val coverType: String = "Twarda_okładka"
}

class Encyclopaedia(name: String) extends Book(name){
  override val coverType: String = "Niebieska_twarda_okładka"
}

object BookApp extends App {
  val dictionary: Book = new Dictionary("Collins")
  val encyclopedia: Book = new Encyclopaedia("Britannica")
  val theBoringBook: Book = new Book("NudnaKsiążka")

  println(s"${dictionary.title} ma okładkę ${dictionary.cover("Słownik_Collinsa")}")
  println(s"${encyclopedia.title} ma okładkę ${encyclopedia.cover("Britannica")}")
  println(s"${theBoringBook.title} ma okładkę ${theBoringBook.cover("Pewna książka")}")
}

/*book.addChapter(Chapter("Rozdział1", 1, 15))
  book.addChapter(Chapter("Rozdział2", 2, 13))
  book.addChapter(Chapter("Rozdział3", 3, 17))*/

class CustomStack extends util.ArrayList[String] {
  def push(value: String) = ???
  def pop = ???
}