package chapter10

object AbstractTypes extends App {

  trait ColumnParameterized[T] {
       def column() : T
  }

  trait ColumnAbstract {
    type T

    def column(): T
  }

  val aColumnFromParameterized = new ColumnParameterized[String] {
    override val column = "MIASTO"
  }

  val aColumnFromAbstract = new ColumnAbstract {
    type T = String

    override val column = "NR_DOMU"
  }

  println(s"Kolumna z typu parametryzowanego: ${aColumnFromParameterized.column}  |  i kolumna z typu abstrakcyjnego: ${aColumnFromAbstract.column} ")
}