package chapter13

/*object TowardsLocking extends App {
  var counter = 0 // Zmienna counter.

  def readWriteCounter(): Int = {
    val incrementedCounter = counter + 1  // Odczyt zmiennej counter.
    counter = incrementedCounter // Zapis zmiennej counter.
    incrementedCounter
  }

  def printCounter(nTimes: Int): Unit = {
    val readWriteCounterNTimes = for(i <- 1 to nTimes) yield readWriteCounter()
    println(s"Wykonywanie wątku ${Thread.currentThread.getName}  :: counter $nTimes razy:  $readWriteCounterNTimes")
  }

  class First extends Thread {
    override def run(): Unit = {
      printCounter(10)
    }
  }

  val first = new First
  first.start() // thread-0

  printCounter(10)   // Wątek główny (main).

}*/

object TowardsLockingOne extends App {
  var counter = 0 // Zmienna counter.

  def readWriteCounter(): Int = this.synchronized {
    val incrementedCounter = counter + 1  // Odczyt zmiennej counter.
    counter = incrementedCounter // Zapis zmiennej counter.
    incrementedCounter
  }

  def printCounter(nTimes: Int): Unit = {
    val readWriteCounterNTimes = for(i <- 1 to nTimes) yield readWriteCounter()
    println(s"Wykonywanie wątku ${Thread.currentThread.getName} :: counter $nTimes razy:  $readWriteCounterNTimes")
  }

  class First extends Thread {
    override def run(): Unit = {
      printCounter(10)
    }
  }

  val first = new First
  first.start() // thread-0

  printCounter(10)   // Wątek główny (main).
}
