package restaurant

import restaurant.privaterestaurant.PrivateRestaurant
import restaurant.protectedrestaurant.ProtectedRestaurant

case class Dish(name: String)

class Restaurant


package privaterestaurant{

  trait Kitchen {
    self: Restaurant =>

    private[privaterestaurant]  val secret = "Tajna wartość" // Potraktuj secret jako logiczną operację prowadzącą do obliczenia wartości, która ma nie być udostępniana.

    def cookMyDish: Option[Dish] = Some(Dish(secret))

  }

  class  PrivateRestaurant  extends Restaurant with Kitchen  {

    def serveDishWithSecret = Dish(secret) // W tym miejscu element składowy secret jest niedostępny.

    private[this] val magicSecret = "magic"

    def serveDish = cookMyDish // To działa świetnie.
  }

}

package  protectedrestaurant {

  import restaurant.privaterestaurant.Kitchen

  class ProtectedRestaurant extends Restaurant with Kitchen {

    //def serveDishWithSecret = Dish(secret) // W tym miejscu element składowy secret jest niedostępny.

    def serveDish = cookMyDish // To działa świetnie.
  }

}

object privateApp extends App{
  val privateRestaurant = new PrivateRestaurant()
  val protectedRestaurant = new ProtectedRestaurant()

  println(s"private[this] : ${protectedRestaurant}")

  //println(s"private ${privateRestaurant.getClass.getPackage} i ${privateRestaurant.secret}")
  //println(s"protected ${protectedRestaurant.getClass.getPackage} i ${privateRestaurant.secret}")

}


