package example

import scala.io.BufferedSource
import scala.util.{Failure, Success, Try}

object PlayerService {

  def readPlayerDataFromSource(src: String): List[String] = {
    val source: BufferedSource = io.Source.fromFile(src)
    val list: List[String] = source.getLines().toList

    source.close()
    list
  }

  def parseToPlayer(string: String): Option[Player] = {
    Try {
      val columns = string.split((",")).map(_.trim)
      Player(columns(5), columns(6), columns(9).toInt, columns(7))
    } match {
      case Success(value) => Some(value)
      case Failure(excep) => None
    }
  }

  def showPlayerInformation(playerOp: Option[Player]): Unit = {
    playerOp.map { player =>
      println("------------ Oto informacje o zawodniku ----------- ")
      println(s"Imię i nazwisko: ${player.name}")
      println(s"Wiek: ${player.age} | Narodowość: ${player.nationality} | Liga: ${player.league}")
      println
    }
  }

  case class Player(name: String, nationality: String, age: Int, league: String)
}
