package example

import akka.actor.{Actor, ActorSystem, OneForOneStrategy, Props, ActorLogging}

import scala.concurrent.duration._

object SupervisionStrategyInPractice extends App {
  val system = ActorSystem("anActorSystem")

  val topLevelActor = system.actorOf(TopLevelActor.props)

  // Wysłanie sygnału StopIt.
  topLevelActor ! TopLevelActor.StopIt
  // Wysłanie sygnału RestartIt.
  topLevelActor ! TopLevelActor.RestartIt
}

class TopLevelActor extends Actor with ActorLogging {
  import akka.actor.SupervisorStrategy.{Resume, Restart}
  import TopLevelActor._

  override val preStart = log.info(s"TopLevelActor - uruchomienie!")
  override val postStop = log.info(s"TopLevelActor - uruchomienie!")

  val superSimpleActor = context.actorOf(SuperSimpleActor.props)

  override def receive = {
    case StopIt => superSimpleActor ! SuperSimpleActor.ArithmeticOpRequest
    case RestartIt => superSimpleActor ! SuperSimpleActor.OtherMessage
  }

  override val supervisorStrategy =
    OneForOneStrategy(
      maxNrOfRetries = 3,
      withinTimeRange = 1 minute
    ){
      case _: ArithmeticException => {
        log.info("Nadzorca obsługuje ArithmeticException! n Wstrzymanie działania!")
        Resume
      }
      case _: Exception => {
        log.info("Nadzorca obsługuje Exception! n Ponowne uruchomienie!")
        Restart
      }
    }
}

object TopLevelActor {
  val props = Props[TopLevelActor]

  case object StopIt
  case object RestartIt
}

class SuperSimpleActor extends Actor with ActorLogging {
  import SuperSimpleActor._

  override val preStart = log.info(s"SuperSimpleActor - uruchomienie!")
  override val postStop = log.info(s"SuperSimpleActor - zatrzymanie!")

  override def preRestart(reason: Throwable, message: Option[Any]): Unit =
    log.info(s"SuperSimpleActor - ponowne uruchomienie!")

  override def receive = {
    case ArithmeticOpRequest => 1 / 0
    case OtherMessage => throw new Exception("Nastąpiło zgłoszenie pewnego wyjątku!")
  }

}

object SuperSimpleActor {
  val props = Props[SuperSimpleActor]

  case object ArithmeticOpRequest
  case object OtherMessage
}