#!/bin/bash
#byLeal

function dohelp(){
	echo "+-------------------------------------------------------------+"
	echo "| Prosty skrypt do utworzenia kont użytkowników               |"
	echo "| w AD/DC (Samba 4 Server) Implementing Samba 4               |"
	echo "|                                                             |"
	echo "|                              Copyright(c) 2013 Marcelo Leal |"
	echo "+-------------------------------------------------------------+"
	echo " Użycie:"
	echo ""
	echo " \"-h\" wyświetlenie tego komunikatu"
	echo " \"-c\" utworzenie kont użytkowników (bez informacji dodatkowych)."
	echo " \"-v\" utworzenie kont użytkowników (z informacjami dodatkowymi)," 
	echo "        pokazując rzeczywiste polecenia powłoki."
	echo ""
	echo " Aby utworzyć konta użytkowników, skrypt korzysta z pliku o nazwie users.txt,"
	echo " który musi znajdować się w katalogu bieżącym."
	echo ""
	echo " Kody błędów: 	(0) OK," 
	echo "			(1) Nieprawidłowe opcje," 
	echo "			(2) Błąd w trakcie tworzenia co najmniej jednego konta użytkownika,"
	echo "			(3) Nie można otworzyć pliku users.txt."
}

function docreate() {
        # Argumenty...
        verbose=$1
	# Pewne zmienne zachowują ewentualnie wygenerowane błędy...
	TOTALE=0; TOTALP=0; TOTALG=0
	# Czy mamy plik users.txt?
	if [ ! -f ./users.txt ]; then
		echo "-> BŁĄD: Nie można znaleźć pliku users.txt.";
		exit 3;
	fi
	while IFS=" " read first last
	do
		let TOTALG=TOTALG+1;
		# Wiersz jest przetwarzany, jeśli zawiera imię ORAZ nazwisko...
		if [ `echo "$first $last" | wc -w` -eq 2 ]; then
			# Zarówno imię jak i nazwisko musi składać się z co najmniej dwóch liter...
			if [ `echo "$first" | wc -c` -gt 2 ] && [ `echo "$last" | wc -c` -gt 2 ]; then
				# Inicjalizacja zmiennych...
				name="${first[@]^}"
				surname="${last[@]^}"
				initials="${name::1}${surname::1}"
				username=`echo "${name::1,2}${surname}" | tr [:upper:] [:lower:]`
				# Wykonanie polecenia rzeczywiście tworzącego konto użytkownika...
				if [ $verbose == "-v" ]; then
					echo "/usr/local/samba/bin/samba-tool user add \"$username\" \'pa\$\$w0rd!\'  --userou=\"ou=Użytkownicy standardowi,ou=People\" \
					--surname=\"$surname\" --given-name=\"$name\" --initials=\"$initials\"  --company=\"EALL\" \
					--description=\"Użytkownik standardowy\" --must-change-at-next-login --mail-address=\"$username@eall.com.br\""
				fi
				eval /usr/local/samba/bin/samba-tool user add \"$username\" \'pa\$\$w0rd!\'  --userou=\"ou=Użytkownicy standardowi,ou=People\" \
				     --surname=\"$surname\" --given-name=\"$name\" --initials=\"$initials\"  --company=\"EALL\" \
				     --description=\"Użytkownik standardowy\" --must-change-at-next-login --mail-address=\"$username@eall.com.br\" >/dev/null 2>&1
				if [ $? -eq 0 ]; then
					echo "Utworzenie konta użytkownika $username zakończyło się powodzeniem."
					let TOTALP=TOTALP+1;
				else
					echo "-> BŁĄD podczas tworzenia konta użytkownika: \"$username\"."
					let TOTALE=TOTALE+1;
				fi
			else
				echo "-> BŁĄD podczas przetwarzania: \"$first $last\". Zarówno imię jak i nazwisko muszą mieć po więcej niż tylko jedną literę...";
				let TOTALE=TOTALE+1;
			fi
		else
			echo "-> BŁĄD podczas przetwarzania: \"$first $last\". Wymagane jest podanie imienia ORAZ nazwiska...";
			let TOTALE=TOTALE+1;
		fi;	
	done <./users.txt
	echo "----------------------------------------------------------"
	echo "Liczba utworzonych kont użytkowników: $TOTALP"
	echo "Całkowita liczba błędów: $TOTALE"
	echo "Całkowita liczba przetworzonych kont użytkowników: $TOTALG"
	echo "----------------------------------------------------------"
	if [ $TOTALE -gt 0 ]; then
		exit 2;
	else
		exit 0;
	fi
}

# Gra...
if [ $# -ne 1 ]; then
	dohelp;
	exit 1;
fi


case "$1" in
	-h) dohelp 
	;;
	-c) docreate "-c" 
	;;
	-v) docreate "-v"
	;;
	*) dohelp; exit 1
	;;
esac
