#!/usr/bin/python
# Przykładowy skrypt z rozdziału 9.

# Wczytywanie...
import samba
from samba import param
from samba.samdb import SamDB
from samba.credentials import Credentials

lp = param.LoadParm()
badge = Credentials()
badge.guess(lp)
badge.set_username('Administrator')
badge.set_password('w1ndow$$!')

# Wiązanie...
cx = SamDB(url='ldap://localhost',
                lp=lp,
                credentials=badge)

# Wyszukiwanie...
search_result = cx.search('DC=poa,DC=msdcbrz,DC=eall,DC=com,DC=br',
                                scope=2,
                                expression='(objectClass=user)',
                                attrs=["samaccountname"])

# Wyniki...
for username in search_result:
        print("Użytkownik: %s" % username.get("samaccountname", idx=0))
