class SlideshowsController < ApplicationController
  # GET /slideshows
  # GET /slideshows.xml
  def index
    @slideshows = Slideshow.find(:all)

    respond_to do |format|
      format.html # index.html.erb
      format.xml  { render :xml => @slideshows }
    end
  end

  # GET /slideshows/1
  # GET /slideshows/1.xml
def show
   @slideshow = Slideshow.find(params[:id])
   session[:slideshow] = @slideshow
   session[:slide_index] = 0
   @slide = @slideshow.slides[0]
 end

  # GET /slideshows/new
  # GET /slideshows/new.xml
  def new
    @slideshow = Slideshow.new

    respond_to do |format|
      format.html # new.html.erb
      format.xml  { render :xml => @slideshow }
    end
  end

  # GET /slideshows/1/edit
  def edit
    @slideshow = Slideshow.find(params[:id])
    session[:slideshow] = @slideshow
    @photos = @slideshow.unused_photos
    @all_categories = Category.find(:all, :order=>"name")
  end

  # POST /slideshows
  # POST /slideshows.xml
  def create
    @slideshow = Slideshow.new(params[:slideshow])

    respond_to do |format|
      if @slideshow.save
        flash[:notice] = 'Slideshow was successfully created.'
        format.html { redirect_to(@slideshow) }
        format.xml  { render :xml => @slideshow, :status => :created, :location => @slideshow }
      else
        format.html { render :action => "new" }
        format.xml  { render :xml => @slideshow.errors, :status => :unprocessable_entity }
      end
    end
  end

  # PUT /slideshows/1
  # PUT /slideshows/1.xml
  def update
    @slideshow = Slideshow.find(params[:id])

    respond_to do |format|
      if @slideshow.update_attributes(params[:slideshow])
        flash[:notice] = 'Slideshow was successfully updated.'
        format.html { redirect_to(@slideshow) }
        format.xml  { head :ok }
      else
        format.html { render :action => "edit" }
        format.xml  { render :xml => @slideshow.errors, :status => :unprocessable_entity }
      end
    end
  end

  # DELETE /slideshows/1
  # DELETE /slideshows/1.xml
  def destroy
    @slideshow = Slideshow.find(params[:id])
    @slideshow.destroy

    respond_to do |format|
      format.html { redirect_to(slideshows_url) }
      format.xml  { head :ok }
    end
  end

 def show_slide
   @slideshow = session[:slideshow]
   session[:slide_index] += 1
   @slide = @slideshow.slides[session[:slide_index]]
   if @slide == nil
      session[:slide_index] = 0
      @slide = @slideshow.slides[0]
   end
   render :partial => "show_slide"
 end

  def update_slide_order
   params[:sortable_thumbs].each_with_index do |id, position|
      Slide.update(id, :position => position)
   end
  end


   def add_photo
     photo_id = params[:id].split("_")[1]
     session[:slideshow] = @slideshow = Slideshow.find(session[:slideshow].id)
     @slide = @slideshow.slides.build(:photo_id => photo_id)
     flash[:notice] = 'Problem: nie mona doda fotografii.'
   end

    def remove_slide
      @slide = Slide.find(params[:id].split("_")[1])
      session[:slideshow] = @slideshow = @slide.slideshow
      @unused_photo = @slide.photo
      @slide.destroy
    end

    def change_filter
      category_id = params[:category_id] || 1
      session[:category_id] = category_id
      session[:slideshow] = @slideshow = Slideshow.find(session[:slideshow].id)
      category = Category.find(category_id)
      render :partial => 'unused_photo',
        :collection => category.photos_including_child_categories - @slideshow.photos
    end

 end
