require 'test_helper'

class PhotoTest < ActiveSupport::TestCase
  fixtures :photos 
  
  def test_photo_count 
    assert_equal 9, Photo.count 
  end 
  
  def test_should_load_photo_attributes 
    assert_equal 1, photos(:photo_1).id 
    assert_equal photos(:photo_1), Photo.find(1) 
    assert_equal 2, photos(:photo_2).id 
    assert_equal Photo.find(2), photos(:photo_2) 
  end 
  
  def test_should_delete_one_photo 
    assert_difference 'Photo.count', -1 do 
      photos(:photo_1).destroy 
    end 
  end 
    
  def test_should_create_one_photo 
    assert_difference 'Photo.count' do 
      Photo.create(:filename => 'armadillo.jpg', :thumbnail =>  'armadillo_t.jpg') 
    end 
  end 
  
  def test_should_have_working_associations 
     assert_working_associations 
   end 

end
