def synchronized(o)
  if block_given?
    o.mutex.synchronize { yield }
  else
    SynchronizedObject.new(o)
  end
end
# Delegacyjna klasa osonowa zapewniajca bezpieczestwo wtkom za pomoc metody method_missing.
# Zamiast rozszerzy klas Object i delegowa metody, rozszerzasz klas
# BasicObject, ktra jest zdefiniowana w Ruby 1.9. Klasa BasicObject nie
# dziedziczy po klasie Object ani module Kernel, a wic jej obiekty nie mog
# wywoywa adnych metod najwyszego poziomu  po prostu ich tam nie ma.
class SynchronizedObject < BasicObject
  def initialize(o); @delegate = o;  end
  def __delegate; @delegate; end
  def method_missing(*args, &block)
    @delegate.mutex.synchronize {
      @delegate.send *args, &block
    }
  end
end
