# Niniejszy modu dostarcza staych definiujcych acuchy UTF-8 dla
# wszystkich punktw kodowych Unicode. Definiuje je leniwie za pomoc metody const_missing.
# Przykady:
#   copyright = Unicode::U00A9
#   euro = Unicode::U20AC
#   infinity = Unicode::U221E
module Unicode
  # Niniejsza metoda pozwala na leniwe definiowanie staych punktw kodowych Unicode.
  def self.const_missing(name)  # Niezdefiniowana staa przekazana jako symbol.
    # Sprawdzenie, czy nazwa staej ma poprawny format 
    # musi by wielka litera U z liczb szesnastkow z przedziau 0000 - 10FFFF.
    if name.to_s =~ /^U([0-9a-fA-F]{4,5}|10[0-9a-fA-F]{4})$/
      # $1 to dopasowana liczba szesnastkowa. Zostaje ona przekonwertowana na liczb cakowit.
      codepoint = $1.to_i(16)
      # Konwersja liczby na acuch UTF-8 za pomoc metody Array.pack.
      utf8 = [codepoint].pack("U")
      # Sprawienie, e nie mona modyfikowa tego acucha UTF-8.
      utf8.freeze
      # Definicja prawdziwej staej, aby przyspieszy kolejne wyszukiwania, i zwrcenie
      # tym razem tekstu UTF-8.
      const_set(name, utf8)
    else
      # Zgoszenie wyjtku dla staych w nieprawidowym formacie.
      raise NameError, "Niezainicjowana staa: Unicode::#{name}"
    end
  end
end
