class XMLGrammar
  # Utwrz egzemplarz tej klasy, okrelajc strumie lub obiekt do
  # przechowywania danych. Obiekt musi odpowiada na <<(String).
  def initialize(out)
    @out = out  # Gdzie maj by wysyane dane.
  end
  # Wywouje blok w egzemplarzu, ktry wysya dane do wyznaczonego strumienia.
  def self.generate(out, &block)
    new(out).instance_eval(&block)
  end
  # Definiuje dozwolony element (czyli znacznik) w gramatyce.
  # Niniejsza metoda jest jzykiem DSL specyfikujcym gramatyk
  # oraz definiuje metody skadajce si na jzyk DSL generujcy XML.
  def self.element(tagname, attributes={})
    @allowed_attributes ||= {}
    @allowed_attributes[tagname] = attributes
    class_eval %Q{
      def #{tagname}(attributes={}, &block)
        tag(:#{tagname},attributes,&block)
      end
    }
  end
  # Te stae s uywane podczas definiowania wartoci atrybutw.
  OPT = :opt     # Dla atrybutw opcjonalnych.
  REQ = :req     # Dla atrybutw wymaganych.
  BOOL = :bool   # Dla atrybutw, ktrych wartoci jest ich wasna nazwa.
  def self.allowed_attributes
    @allowed_attributes
  end
  # Wysya wyznaczony obiekt jako CDATA, zwraca warto nil.
  def content(text)
    @out << text.to_s
    nil
  end
  # Wysya wyznaczony obiekt jako komentarz, zwraca warto nil.
  def comment(text)
    @out << "<!-- #{text} -->"
    nil
  end
  # Wysya znacznik o wyznaczonej nazwie i z okrelonym atrybutem.
  # Jeli istnieje jaki blok, zostaje wywoany, aby zwrci lub wysa tre.
  # Return nil.
  def tag(tagname, attributes={})
    # Wysya nazw znacznika.
    @out << "<#{tagname}"
    # Sprawdza dozwolone atrybuty tego znacznika.
    allowed = self.class.allowed_attributes[tagname]
    # Najpierw naley si upewni, e kady z tych atrybutw jest dozwolony.
    # Zakadajc, e wszystkie s dozwolone, wysyane s wszystkie wyznaczone.
    attributes.each_pair do |key,value|
      raise "nieznany atrybut: #{key}" unless allowed.include?(key)
      @out << " #{key}='#{value}'"
    end
    # Przeglda dozwolone atrybuty, aby sprawdzi, czy nie zostay
    # pominite adne wymagane atrybuty oraz czy s atrybuty z wartociami
    # domylnymi, ktre mona wysa na wyjcie.
    allowed.each_pair do |key,value|
      # Jeli ten atrybut zosta ju wysany, nic si nie dzieje.
      next if attributes.has_key? key
      if (value == REQ)
        raise "brak wymaganego atrybutu '#{key}' w znaczniku <#{tagname}>"
      elsif value.is_a? String
        @out << " #{key}='#{value}'"
      end
    end
    if block_given?
      # Ten blok zawiera tre.
      @out << '>'             # Zakoczenie znacznika otwierajcego.
      content = yield         # Wywoanie bloku, aby wysa lub zwrci tre.
      if content              # Jeli zostanie zwrcona jaka tre,
        @out << content.to_s  # bdzie wysana na wyjcie jako acuch.
      end
      @out << "</#{tagname}>" # Zamknicie znacznika.
    else
      # W przeciwnym przypadku jest to znacznik pusty, a wic naley tylko go zamkn.
      @out << '/>'
    end
    nil # Znaczniki wysyaj same siebie, a wic nie zwracaj adnej treci.
  end
end
