#
# Definicja metod after i every z moduu Kernel, aby opniay wykonywanie blokw kodu.
# Przykady:
#
#   after 1 { puts "koniec" }
#   every 60 { redraw_clock }
#
# Obie te metody zwracaj obiekty klasy Thread. Aby anulowa wykonywanie tego kodu,
# naley wywoa metod kill na rzecz tych obiektw.
#
# Pamitaj, e jest to bardzo prosta implementacja. Bardziej niezawodna wersja,
# dla wszystkich zada uywaaby jednego globalnego wtku mierzcego czas oraz
# umoliwiaaby sprawdzanie wartoci opnionego bloku i poczekanie
# na zakoczenie wszystkich zada.
#
# Wykonuje blok kodu po odczekaniu wyznaczonej liczby sekund.
def after(seconds, &block)
  Thread.new do     # Nowy wtek...
    sleep(seconds)  # Pierwsze zanicie.
    block.call      # Wywoanie bloku.
  end               # Zwrcenie natychmiast obiektu klasy Thread.
end
# Wielokrotnie usypia, a nastpnie wykonuje blok kodu.
# Przekazuje do bloku warto przy pierwszym wywoaniu.
# Do kolejnych wywoa przekazuje warto poprzedniego wywoania.
def every(seconds, value=nil, &block)
  Thread.new do                 # Nowy wtek...
    loop do                     # Powtarzanie w nieskoczono (lub do instrukcji break w bloku)
      sleep(seconds)            # Zanicie.
      value = block.call(value) # Wywoanie bloku.
    end                         # Nastpne powtrzenie..
  end                           # Metoda every zwraca obiekt klasy Thread.
end
