class XML
  # Utwrz egzemplarz tej klasy, okrelajc strumie lub obiekt do
  # przechowywania danych wyjciowych. Moe to by dowolny obiekt odpowiadajcy na <<(String).
  def initialize(out)
    @out = out  # Zapamituje, gdzie maj zosta wysane dane wyjciowe.
  end
  # Wysya wyznaczony obiekt jako CDATA, zwraca warto nil.
  def content(text)
    @out << text.to_s
    nil
  end
  # Wysya wyznaczony obiekt jako komentarz, zwraca warto nil.
  def comment(text)
    @out << "<!-- #{text} -->"
    nil
  end
  # Wysya znacznik o okrelonej nazwie i z okrelonymi atrybutami.
  # Jeli jest blok, zostanie wywoany, aby wysa lub zwrci tre.
  # Zwraca warto nil.
  def tag(tagname, attributes={})
    # Wysanie nazwy znacznika.
    @out << "<#{tagname}"
    # Wysanie atrybutw.
    attributes.each {|attr,value| @out << " #{attr}='#{value}'" }

    if block_given?
      # Ten blok zawiera tre.
      @out << '>'             # Zakoczenie znacznika otwierajcego.
      content = yield         # Wywoanie bloku, aby wysa lub zwrci tre.
      if content              # Jeli zostaa zwrcona jaka tre,
        @out << content.to_s  # zostanie wysana jako acuch.
      end
      @out << "</#{tagname}>" # Zamknicie znacznika.
    else
      # W przeciwnym przypadku jest to znacznik pusty, a wic zostaje tylko zamknity.
      @out << '/>'
    end
    nil # Znaczniki wysyaj si same, a wic nie zwracaj adnej treci.
  end
  # Poniszy kod odpowiada za zamian tej klasy w jzyk DSL.
  # Po pierwsze: kada nieznana metoda jest traktowana jako nazwa znacznika.
  alias method_missing tag
  # Po drugie: uruchamia blok w nowym egzemplarzu klasy.
  def self.generate(out, &block)
    XML.new(out).instance_eval(&block)
  end
end
