#!/usr/bin/env ruby

2.class # => Fixnum
2.0.class # => Float
2_000_000_000.class # => Bignum

Fixnum.ancestors # => [Fixnum, Integer, Precision, Numeric, Comparable, Object, Kernel]
Object.included_modules # => [Kernel]
Numeric.included_modules # => [Comparable, Kernel]
Integer.included_modules # => [Precision, Comparable, Kernel]
Fixnum.included_modules # => [Precision, Comparable, Kernel]

Integer(1.4) # konwersja liczby zmiennoprzecinkowej
Integer("256") # konwersja acucha
Integer("0b11110010") # konwersja liczby dwjkowej z acucha
Integer(0177) # konwersja liczby semkowej
Integer(0x20) # konwersja liczby szesnastkowej
Integer(?z) # konwersja kodu znaku

Float(167) # konwersja liczby zmiennoprzecinkowej
Float("77") # konwersja acucha
Float(?a) # konwersja kodu znaku

7 + 5 # dodawanie
20 - 8 # odejmowanie
2 * 6 # mnoenie
144 / 12 # dzielenie
12**2 # potgowanie
12 % 5 # modulo (reszta z dzielenia)
+7 + -5
-20 + 32
-20 - +32
20 * -8 

24.div 2 # dzielenie
(25.0).div(2.0) # wynikiem jest liczba cakowita
12.modulo 5 # modulo
12.modulo(5.0) # modulo z liczbami zmiennoprzecinkowymi
12.divmod 5 # zwraca tablic z ilorazem i reszt
12.0.divmod 5.0 # zmiennoprzecinkowe
12.quo 5 # zwraca iloraz
12.remainder 5 # zwraca reszt z dzielenia

24 / 2 # nie ma problemu => 12
25 / 2 # oho, obcicie => 12
25.0 / 2 # przynajmniej jeden argument zmiennoprzecinkowy  rozwizuje problem => 12.5
25.0 / 2.0 # to samo, jeli oba argumenty s zmiennoprzecinkowe => 12.5

12 == 24/2 # => true
24.eql?(12*2) # => true
12 == 14 # => false
12 <=> 12 # => 0
12 <=> 10 # => 1
12 <=> 14 # => -1

12 < 14 # => true
12 < 12 # => false
12 <= 12 # => true
12.0 > 11.9 # => true
12.0 >= 12 # => true

x = 0
x = x + 1
x += 1

x = 12 # zwyke przypisanie
x += 6 # dodawanie
x -= 12 # odejmowanie 
x *= 4 # mnoenie 
x /= 8 # dzielenie 
x **= 2 # potgowanie
x %= 3 # modulo 
x # zwraca warto zmiennej

~1011 # bitowa negacja (dopenienie) => -1012
1011 | 1010 # bitowe LUB => 1011
1011 & 1010 # bitowe I => 1010
1011 ^ 1010 # bitowe wyczne LUB => 1
1011 # przesunicie w lewo => 2022
1011 # przesunicie w prawo => 505

-40.abs # => 40
40.abs # => 40
4.65.ceil # => 5 
4.65.floor # => 4
100.45.round # => 100
100.49.round # => 100
100.5.round # => 101
100.6.round # => 101

(1..25) === 14 # => true, w zakresie
(1..25) === 26 # => false, poza zakresem
(1...25) === 25 # => false, poza zakresem (uylimy operatora ...)
(1..9).to_a # => [1, 2, 3, 4, 5, 6, 7, 8, 9]
digits = Range.new(1, 9)
digits.to_a # => [1, 2, 3, 4, 5, 6, 7, 8, 9]

op = 0

if !op.zero? # nie zero?
   puts 12 / op
else
   puts "Nie mona dzieli przez zero."
end

op = 2

if op.nonzero? # nie zero?
   puts 12 / op
else
   puts "Nie mona dzieli przez zero."
end

12.integer? # => true
12.0.integer? # => false
-1.integer? # => true
-12.integer? # => true

num = 4 # => 4

if num.integer?
   puts "Liczba zaproszonych goci: " + num.to_s
else
   puts "Tylko kompletne osoby mog przyj na przyjcie."
end

0.0.finite? # => true
(-1.0/0.0).finite? # => false
(+1.0/0.0).finite? # => false

0.0.infinite? # => nil
(-1.0/0.0).infinite? # => -1
(+1.0/0.0).infinite? # => 1

val = 1.0
val.nan? # => false
val = 0.0/0.0
val.inspect # => "NaN"
val.nan? # => true

-24.next # => -23
1.next # => 2
999.next # => 1000
97.chr # => "a"
98.chr # => "b"
125.chr # => "}"
126.chr # => "~"
127.chr # => "\177"

10.times { |i| print i, " " } # => 0 1 2 3 4 5 6 7 8 9
10.times { |i| print 5*i, " " } # => 0 5 10 15 20 25 30 35 40 45

10.times do |i|
  puts 5*i
end

10.times do |i| print 5*i, " " end

# uruchomi osobno
=begin
100.downto(1) { |c| print c, " "; sleep 1 }

1.upto(100) { |c| print c, " "; sleep 1 }
=end

print Math::E # => 2.71828182845905
print Math::PI # => 3.14159265358979

Math.exp(1) # => 2.71828182845905
Math.exp(11) # => 59874.1417151978

Math.sqrt(4) # => 2.0
Math.sqrt(16) # => 4.0
Math.sqrt(144) # => 12.0

Math.log(Math::E) # => 1.0
Math.log(1) # => 0.0
Math.log(0) # => -Infinity
Math.log10(100.0) # => 2.0

"In the early morning astronomers spiritualized nonmathematicians".split.each { |p| print p.length, " " }

