#!/usr/bin/env ruby

Dir.chdir( "Ratios" )
home = Dir.pwd
p home 
Dir.chdir( ".." )

ruby_progs = "."

if not Dir.pwd == ruby_progs
  Dir.chdir ruby_progs
end

Dir.mkdir( "sandbox" )
Dir.rmdir( "sandbox" )
Dir.mkdir( "sandbox", 755 )
Dir.rmdir( "sandbox" )

Dir.entries( "." ).each { |e| puts e }

Dir.foreach( "/usr/local/src/ruby-1.8.6" ) { |e| puts e }

dir = Dir.open( "." )
dir.path
dir.tell
dir.read
dir.tell
dir.rewind
dir.each { |e| puts e } # wysya wszystkie pozycje z katalogu
dir.close

file = File.new( "f.rb", "w" )
file.close
File.delete( "f.rb" )

file = File.open( "sonnet_129.txt" )
file.each { |line| print "#{file.lineno}. ", line }
file.close

ARGV << "sonnet_129.txt"
print while gets

p ARGV # => ["sonnet_119.txt"]

ARGV#[0] # => ["sonnet_119.txt"]

File.new( "books.txt", "w" )
File.rename( "books.txt", "chaps.txt" )
File.delete( "chaps.txt" )

File::open("x.txt") if File::exists?( "x.txt" )

File.file?( "sonnet29.txt" ) # => true

File::directory?( "/usr/local/bin" ) # => true

File::directory?( "access.rb" ) # => false
File.readable?( "sonnet_119.txt" ) # => true
File.writable?( "sonnet_119.txt" ) # => true
File.executable?( "sonnet_119.txt" ) # => false

system("touch chap.txt") # tworzymy nowy plik o zerowej dugoci za pomoc polecenia systemowego
File.zero?( "chap.txt" ) # => true
File.delete( "chap.txt" )

File.size?( "sonnet_129.txt" ) # => 594
File.size( "sonnet_129.txt" ) # => 594

File::ftype( "access.rb" ) # => "file"

File::ctime( "access.rb" )
File::mtime( "access.rb" )
File::atime( "access.rb" )

file = File.new( "books.txt", "w" )
file.chmod( 0755 )
system "ls -l books.txt"
File.delete( "books.txt" )

file = File.new( "books.txt", "w" ).chmod( 0755 )
system "ls -l books.txt"
File.delete( "books.txt" )

file = File.new( "books.txt", "w" ).chmod( 0644 )
system "ls -l books.txt"
File.delete( "books.txt" )

=begin
file = File.new( "books.txt", "r" )
file.chown( 109, 3333 )
system "ls -l books.txt"
File.delete( "books.txt" )

file = File.new( "books.txt", "r" ).chown( 109, 3333 )
system "ls -l books.txt"
File.delete( "books.txt" )
=end

ios = IO.new( 1, "w" )
ios.puts "I/O, I/O, do kodowania by si szo."
$stdout.puts "Czy mnie syszysz? Odbir."
ios.fileno # => 1
ios.to_i # => 1
$stdout.fileno # => 1
ios.close

=begin
ios = IO.new( 1, "w" )
ios << "Przeto nigdy nie pytaj, " << "komu bije dzwon." << " -John Donne"
ios.flush # => "Przeto nigdy nie  pytaj, komu bije dzwon. -John Donne"
ios.close

ios = IO.new( 1 )
ios.putc "M"
ios.putc "a"
ios.putc "t"
ios.putc "z"
ios.getc # => Matz
ios.close
=end

file = File.new( "sonnet_29.txt" )
file.gets # => "Gdy los i ludzie czstuj mnie wzgard,\n"
file.gets # => "Chc miosierdzie wzbudzi w guchym niebie;\n"
file.close

file = File.new( "sonnet_119.txt" )
file.readline # => "Niechaj do prawych umysw zczenia \n"
file.readline # => "adne warunki nie bd przydane.\n"
file.readline # => "Mioci nie jest mio, co si zmienia\n"
file.close