#!/usr/bin/env ruby

months = Array.new
months.empty? # => true

months = Array.new(12)
months = Array.new 12
months.size # => 12
months.length # => 12
puts months.inspect
p months

month = Array.new(12, "month")

month.clear # => []
month.empty? # => true

num = Array.new(10) { |e| e = e * 2 }

months_abbrv = Array.[]( "sty", "lut", "mar", "kwi", "maj", "cze", "lip", "sie", "wrz", "pa", "lis", "gru" )

months_abbrv = Array[ "sty", "lut", "mar", "kwi", "maj", "cze", "lip", "sie", "wrz", "pa", "lis", "gru" ]

months = [ nil, "stycze", "luty", "marzec", "kwiecie", "maj", "czerwiec", "lipiec", "sierpie", "wrzesie", "padziernik", "listopad", "grudzie" ]

digits = Array(0..9) # => [1, 2, 3, 4, 5, 6, 7, 8, 9]

donald_duck_nephews = Array( "Huey" "Dewey" "Louie" )

months = %w[ nil stycze luty marzec kwiecie maj czerwiec lipiec sierpie wrzesie padziernik listopad grudzie ]

months[0] = nil;

year = %w[ 2000 2001 2002 2003 2004 2005 2006 2007 2008 2009 ]
year[0].class # => String

year = [2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009]
year[0].class # => Fixnum

hodge_podge = ["stycze", 1, :year, [2006,01,01]]
hodge_podge.each {|e| print e.class, " " } # => String Fixnum Symbol Array

q1 = %w[ January February March ]
q1[0] # => January
q1[2] # => March
q1.at(0) # => January
years = ["2000", "2001", "2002", "2003", "2004", "2005", "2006", "2007", "2008", "2009"]
print "Zaplanowana data ukoczenia projektu: " + months[3] + " " + years[8] + "."
q1[-1] # => marzec
q1[1]
q1[-2]
q1.first # => stycze
q1.last # => marzec
q1.first 2 # => ["stycze", "luty"]
q1.last 0 # => [] niezbyt praktyczne
q1.index "March" # => 2

year = [2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009]
year[0, 3] # => [2000, 2001, 2002]
year[7..9] # => [2007, 2008, 2009]
year.slice(1) # => 2001
year.slice(0,4) # => [2000, 2001, 2002, 2003]
year.slice(0..2) # => [2000, 2001, 2002]
year.slice(0...2) # => [2000, 2001]
year.include? 2004 # => true
year.include?( 2010 ) # => false

q1 = %w[ stycze luty marzec ]
q2 = %w[ kwiecie maj czerwiec ]
q3 = %w[ lipiec sierpie wrzesie ]
q4 = %w[ padziernik listopad grudzie ]
half1 = q1 + q2
half2 = q3 + q4
yr = half1 + half2
yrs = [1999]
yrs << 2000 # => [1999, 2000]
yrs << 2001 << 2002 << 2003 # => [1999, 2000, 2001, 2002, 2003]
last_part = q3.concat( q4 )

wt = ["i na zakupy", "upiec ciasto", "spa"]
r = ["i na zakupy", "upiec ciasto", "przeczyta ksik", "spa"]
wt & r # => ["i na zakupy", "upiec ciasto", "spa", ""]
r - wt # => ["przeczyta ksik"]
wt | r # => ["i na zakupy", "upiec ciasto", "przeczyta ksik", "spa"]

shopping_list = %w[ ser chleb chipsy ziemniaki marchew ser ] # => ["ser", "chleb", "chipsy", "ziemniaki", "marchew", "ser"]
shopping_list.uniq! # => ["ser", "chleb", "chipsy", "ziemniaki", "marchew"]

fruit = %w [ jabko pomaracza banan ]
fruit.pop # => "banan"
p fruit # => ["jabko", "pomaracza"]
fruit.push "mango"
p fruit # => ["jabko", "pomaracza", "mango"]

bob = ["peny", 40, "tak"]
lou = ["niepeny", 23, "nie"]
schlomo = ["peny", 40, "tak"]
lou == lou # => true
bob == schlomo # => true
schlomo == lou # => false
bob == schlomo # => true
bob.eql?( "peny, 40, tak" ) # => false, bob nie jest acuchem
lou <=> lou # => 0
bob <=> lou # => -1
lou <=> schlomo # => 1

months = %w[ nil stycze luty marzec kwiecie maj czerwiec lipiec sierpie wrzesie padziernik listopad grudzie ]
["nil", "stycze", "luty", "marzec", "kwiecie", "maj", "czerwiec", "lipiec", "sierpie", "wrzesie", "padziernik", "listopad", "grudzie"]
months.insert( 0, nil )
[nil, "stycze", "luty", "marzec", "kwiecie", "maj", "czerwiec", "lipiec", "sierpie", "wrzesie", "padziernik", "listopad", "grudzie"]
months[5..7] = "May", "June", "July" # => [nil, "stycze", "luty", "marzec", "kwiecie", "May", "June", "July", "sierpie", "wrzesie", "padziernik", "listopad", "grudzie"]
months[5, 3] = "maj", "czerwiec", "lipiec" # => [nil, "stycze", "luty", "marzec", "kwiecie", "maj", "czerwiec", "lipiec", "sierpie", "wrzesie", "padziernik", "listopad", "grudzie"]

greeting = [ "Hello!", "Bonjour!", "Guten Tag!" ]
puts greeting.to_s # => Hello! Bonjour! Guten Tag!
months.join # => "styczelutymarzeckwieciemajczerwieclipiecsierpiewrzesiepadzierniklistopadgrudzie"
months.join ", " # => " , stycze, luty, marzec, kwiecie, maj, czerwiec, lipiec, sierpie, wrzesie, padziernik, listopad, grudzie"
months.compact.join ", " # => "stycze, luty, marzec, kwiecie, maj, czerwiec, lipiec, sierpie, wrzesie, padziernik, listopad, grudzie"

dates = [ 4, 5, 6, 7 ] # => [4, 5, 6, 7]
dates.shift # => 4
p dates # => [5, 6, 7]
dates.unshift 4 # => [4, 5, 6, 7]
dates.unshift(2,3) # => [2, 3, 4, 5, 6, 7]

months_a = %w[ nil sty lut mar kwi maj cze lip sie wrz pa lis gru ] # => ["nil", "sty", "lut", "mar", "kwi", "maj", "cze", "lip", "sie", "wrz", "pa", "lis", "gru"]
month_a.delete "nil"
month_a.delete("czwartek") {"Nie znaleziono miesica czwartek. I co teraz?"}
month_a.delete_at( 12 ) # => "gru"
p month_a # => ["nil", "sty", "lut", "mar", "kwi", "maj", "cze", "lip", "sie", "wrz", "pa", "lis"]

month_a.each { |e| print e.capitalize + " " }
month_a_2007 = month_a.map { |e| e.capitalize + " 2007" }
p month_a_2007 # => ["Sty 2007", "Lut 2007", "Mar 2007", "Kwi 2007", "Maj 2007", "Cze 2007", "Lip 2007", "Sie 2007", "Wrz 2007", "Pa 2007", "Lis 2007", "Gru 2007"]

x = [ 2, 5, 1, 7, 23, 99, 14, 27 ]
x.sort! # => [1, 2, 5, 7, 14, 23, 27, 99]
%w[jeden dwa trzy cztery pi sze siedem osiem dziewi dziesi].reverse # => ["dziesi", "dziewi", "osiem", "siedem", "sze", "pi", "cztery", "trzy", "dwa", "jeden"]

d2 = [ ["stycze", 2007],
       ["luty", 2007],
       ["marzec", 2007] ]
yrs = [ 2007, 2008, 2009 ]
days = [ 31, [28, 29], 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ]
months = [ "sty", "lut", "mar", "kwi", "maj", "cze", "lip", "sie", "wrz", "pa", "lis", "gru" ]
d3 = [ yrs, days, months ] # => [[2007, 2008, 2009], [31, [28, 29], 31, 30, 31, 30, 31, 31, 30, 31, 30, 31], ["sty", "lut", "mar", "kwi", "maj", "cze", "lip", "sie", "wrz", "pa", "lis", "gru"]]
d2.flatten # => ["stycze", 2007, "luty", 2007, "marzec", 2007]
d2 = [ ["stycze", 2007], ["luty", 2007], ["marzec", 2007] ]
d2.transpose # => [["stycze", "luty", "marzec"], [2007, 2007, 2007]]
