# TEN SKRYPT MA BYĆ URUCHAMIANY W JUPYTER NOTEBOOK (UŻYŁEM VS CODE)

# %%
import pyodbc
import pandas as pd 

# %%
# Nawiąż połączenie z egzemplarzem SQLExpress z wykorzystaniem uwierzytelniania systemu Windows
conn = pyodbc.connect(
    'Driver={ODBC Driver 17 for SQL Server};'
    r'Server=.\SQLExpress;'
    'Database=master;'
    'Trusted_Connection=yes;')

# %%
# Możesz również, jeśli wolisz, połączyć się z nim za pomocą uwierzytelniania SQL dla użytkownika 'sa'
# conn = pyodbc.connect(
#     'Driver={ODBC Driver 17 for SQL Server};'
#     r'Server=.\SQLExpress;'
#     'Database=master;'
#     'Uid=sa;'
#     'Pwd=<twoje-hasło>')

# %%
# Odczytaj i pokaż wybrane informacje o bazach danych przy użyciu widoku systemowego
data = pd.read_sql("SELECT database_id, name FROM sys.databases", conn)
data.head()

# Odłącz się od egzemplarza SQLExpress
conn.close()

# %%
# Nawiąż połączenie z Azure SQL Database
conn = pyodbc.connect(
    'Driver={ODBC Driver 17 for SQL Server};'
    'Server=<twój-serwer>.database.windows.net;'
    'Database=SystemsLogging;'
    'Uid=<twoja-nazwa-użytkownika>;'
    'Pwd=<twoje-hasło>')

# %%
# Odczytaj i pokaż wybrane informacje o bazach danych na serwerze Azure SQL przy użyciu widoku systemowego
data = pd.read_sql("SELECT database_id, name FROM sys.databases", conn)
data.head()

# %%
# Utwórz w usłudze SystemsLogging Azure SQL Database tabelę WrongEmails.
# Tabela będzie zawierać kolumny 'UserId' i 'Email'.
cursor = conn.cursor()
cursor.execute('''
               CREATE TABLE WrongEmails
               (
               UserId int,
               Email nvarchar(200)
               )
               ''')
conn.commit()

# %%
# Pobierz dane z przykładowej tabeli SalesLT.Customers
data = pd.read_sql('SELECT TOP 10 CustomerID, EmailAddress FROM SalesLT.Customer', conn)
data.head()

# %%
# Zapisz dane klientów do tabeli WrongEmails
cursor = conn.cursor()
# Zapisz ramkę danych do tabeli bazy danych (Azure) SQL Server wiersz po wierszu:
for index, row in data.iterrows():
    cursor.execute("INSERT INTO WrongEmails (UserId, Email) values(?,?)", row.CustomerID, row.EmailAddress)
conn.commit()
cursor.close()

# %%
# Pobierz dane z tabeli WrongEmails i wyświetl je
df = pd.read_sql('SELECT TOP 10 UserId, Email FROM WrongEmails', conn)
df.head()

# %%
# Teraz opróżnij tabelę WrongEmails
cursor = conn.cursor()
cursor.execute('TRUNCATE TABLE WrongEmails')
conn.commit()

# %%
# Zamknij połączenie
conn.close()
# %%
