
library(dplyr)
library(lubridate)
library(ggplot2)
library(naniar)
library(imputeTS)



#-- Diagnozowanie danych tabelarycznych ----
dataset_url <- 'http://bit.ly/titanic-dataset-csv'
tbl <- readr::read_csv(dataset_url)
tbl


# Wykres brakujących wartości w całym zestawie danych 
vis_miss(tbl) +
    theme(
        plot.title = element_text(size=24),
        axis.title = element_text(size=18),
        axis.text = element_text(size=14),
        axis.text.x = element_text(angle = 70),
        legend.text = element_text(size=12)
    )

# Podsumowanie brakujących wartości
miss_var_summary(tbl)

# Wykres liczby brakujących wartości
# dla każdej zmiennej
gg_miss_var(tbl)


# Których kombinacji zmiennych brakuje łącznie? 
gg_miss_upset(tbl, text.scale = 2)



#-- Diagnozowanie danych szeregów czasowych  ----

air_df <- read.csv('https://bit.ly/airpassengers')

# Stwórz 10% brakujących wartości w wektorze
set.seed(57934)
value_missing <- missForest::prodNA(air_df['value'], noNA = 0.1)

# Wymuszenie większej luki w wektorze
value_missing[67:68,] <- NA

# Dodanie wektora z brakującymi wartościami do ramki danych
air_missing_df <- air_df %>% 
    mutate( date = ymd(date) ) %>% 
    rename( complete = value ) %>% 
    bind_cols( value = value_missing )

air_missing_df

# Wizualizacja rozkładu brakujących wartości 
ggplot_na_distribution(air_missing_df$value)

# Uzyskaj statystyki dotyczące brakujących wartości 
statsNA(air_missing_df$value)



