
from presidio_analyzer import AnalyzerEngine
from presidio_anonymizer import AnonymizerEngine
from presidio_anonymizer.entities.engine import OperatorConfig

import secrets
import string


def generateToken(len):
    alphabet = string.ascii_letters + string.digits
    tkn = ''.join(secrets.choice(alphabet) for i in range(len))
    return tkn


# Funkcja używana do anonimizowania tekstu zawierającego adresy e -mail
def anonymizeEmail(text_to_anonymize): 
    analyzer_results = analyzer.analyze(text=text_to_anonymize, entities=["EMAIL_ADDRESS"], language='en')

    anonymized_results = anonymizer.anonymize(
        text=text_to_anonymize,
        analyzer_results=analyzer_results,    
        operators={"EMAIL_ADDRESS": OperatorConfig("replace", {"new_value": generateToken(20)})}
    )

    return anonymized_results.text

# Funkcja używana do anonimizowania tekstu zawierającego nazwiska
def anonymizeName(text_to_anonymize): 
    analyzer_results = analyzer.analyze(text=text_to_anonymize, entities=["PERSON"], language='en')

    anonymized_results = anonymizer.anonymize(
        text=text_to_anonymize,
        analyzer_results=analyzer_results,    
        operators={"PERSON": OperatorConfig("replace", {"new_value": generateToken(20)})}
    )

    return anonymized_results.text


# W celu testowania możesz załadować zawartość pliku Excela bezpośrednio tutaj 
# Wystarczy odkomentować poniższe 3 wiersze. 
# # Załaduj zawartość pliku Excel do ramki danych
# import pandas as pd
# dataset = pd.read_excel(r'D:\<twoja-ścieżka>\Chapter06\CustomersCreditCardAttempts.xlsx', engine='openpyxl')


# Initialize Presidio's analyzer and anonymizer
# https://microsoft.github.io/presidio/supported_entities/
analyzer = AnalyzerEngine()
anonymizer = AnonymizerEngine()

# Utwórz kopię źródłowego zestawu danych 
df = dataset.copy()

# Zastosuj funkcję anonymizeName dla każdej wartości kolumny Name
df.Name = df.Name.apply(lambda x: anonymizeName(x))

# Zastosuj funkcję anonymizeEmail dla każdej wartości kolumny Email 
df.Email = df.Email.apply(lambda x: anonymizeEmail(x))

# Kolumna Notes jest typu danych 'object', ponieważ zawiera dużo wartości NaN i 
# moduł pandas nie rozpoznaje jej jako tekstu. Dlatego należy przekonwertować ją na tekst,
# aby można ją było zanonimizować. Następnie należy zastąpić te wartości wartością zanonimizowaną
df.Notes = df.Notes.astype('str').apply(lambda x: anonymizeName(x) )
df.Notes = df.Notes.astype('str').apply(lambda x: anonymizeEmail(x) )

# # Aby pakiet pandas nie obcinał ciągów w komórkach 
# pd.set_option('display.max_colwidth', None)

# # Wyświetlenie obu ramek danych
# dataset
# df
