
library(dplyr)
library(ggplot2)


# # Aby uruchomić ten kod nie w usłudze Power BI, wykonaj następujące czynności:
# # 1. Uruchom cały kod, który możesz znaleźć w skrypcie '09-create-association-objects.R'
# # 2. Odkomentuj poniższy kod
# numeric_method <- 'pearson'
# categorical_method <- 'theil'
# 
# dataset <- corr_tbl %>% 
#   filter( numeric_corr_type == numeric_method & categorical_corr_type == categorical_method)
# #-----

dataset %>% 
  ggplot( aes(x=row, y=col, fill=corr) ) +
  geom_tile() +
  geom_text(aes(row, col, label = round(corr, 2)), color = "white", size = 4) +
  theme(
    axis.text.x = element_text(angle = 90, hjust = 1, vjust = 0.5),
    axis.text = element_text(size=14)
  )
