
library(tidyr)
library(ggplot2)
library(DataExplorer)
library(summarytools)

# Ładowanie zestawu danych z odpowiednimi typami danych kolumn
init_path <- r'{C:\<your-folder>\Chapter14\R\00-init-dataset.R}'
if(!exists('foo', mode='function')) source(init_path)


# Podstawowe informacje o zestawie danych
basic_info_tbl <- introduce(tbl) %>% 
  pivot_longer(cols = everything(), names_to = 'attribute', values_to = 'value')

duplicated_rows_num <- (
  
    # Na podstawie ogólnej liczby wierszy...
    basic_info_tbl %>% 
      filter( attribute == 'rows' ) %>% 
      pull()
  ) - (
    # ... subtract the number of distinct rows
    tbl %>% 
      distinct() %>% 
      tally() %>% 
      pull()
  )

basic_info_tbl <- basic_info_tbl %>% 
  bind_rows(
    tibble(attribute = 'duplicated_rows', value = duplicated_rows_num)
  )

basic_info_tbl


# Zestaw danych z podsumowaniem
summary_tbl <- data.frame(dfSummary(tbl, graph.col = FALSE, varnumbers = FALSE,
                                    na.col = TRUE, max.distinct.values = 20)) %>% 
  
  # Usuwanie odwrotnego ukośnika, który pozostaje po konwersji na ramkę danych
  mutate_if(is.character, 
            stringr::str_replace_all, pattern = '\\\\', replacement = '') %>% 
  
  # Zmiana nazw nietypowych nazw kolumn po konwersji
  rename( 'Stats Values' = 'Stats...Values', 'Freq of Valid' = 'Freqs....of.Valid.' ) %>% 
  
  # Dodaj kolumny złożone z unikatowych prawidłowych wartości (różnych od null)
  bind_cols(
    tbl %>% 
      summarise_all( ~n_distinct(. ,na.rm = TRUE) ) %>% 
      pivot_longer(cols = everything(), names_to = 'Variable', values_to = 'Unique Valid') %>% 
      mutate( 'Unique Valid' = paste0(`Unique Valid`, ' distinct values') ) %>% 
      select( 'Unique Valid' )
  ) %>% 
  
  # Odpowiednie przenoszenie unikatowych wartości kolumn
  relocate( 'Unique Valid', .before = 'Freq of Valid')
  


# Wzbogacone statystyki opisowe kolumn liczbowych
numeric_vars_descr_stats_tbl <- tbl %>% 
  descr() %>% 
  tb() %>% 
  select( -se.skewness, -n.valid, -pct.valid )

numeric_vars_descr_stats_tbl


sample_tbl <- tbl %>% head(100)

