
# Funkcja serializująca dowolny obiekt do surowego wektora (bajty).
# Następnie przekształca bajty w ciąg bajtów.
to_string_of_bytes = function(x) {
  paste(as.character(serialize(x, connection = NULL)), collapse = " ")
}

# Funkcja, która tnie ciąg 's' i tworzy z niego wektor o stałej szerokości złożony ze znaków.
str_dice <- function(s, width) {
  substring(
    s,
    seq(1, nchar(s), width),
    seq(width, nchar(s) + ifelse(nchar(s) %% width > 0, width-1, 0), width)
  )
}


project_folder <- "c:\\Users\\User\\Desktop\\Extending Power BI\\kod\\Extending-Power-BI-with-Python-and-R-main\\Chapter04\\importing-rds-files"

# Deserializuj listę wykresów.
deserialized_lst <- readRDS( file.path(project_folder, "plots_lst.rds") )

# Deserializuj obiekt tibble wybranych krajów.
selected_countries_df <- data.frame( country_name = names(plots_lst) )

# Zastosuj do każdego elementu listy wykresów funkcję to_string_of_bytes.
# W wyniku otrzymasz listę zserializowanych wykresów w postaci ciągu bajtów.
plots_str_lst <- lapply(plots_lst, to_string_of_bytes)

# Podziel każdy ciąg bajtów na fragmenty po 10 000, aby uniknąć ograniczeń długości ciągu w wizualizacji języka R
plots_str_vec_lst <- lapply(plots_str_lst, str_dice, width = 10000)


# Utwórz pustą ramkę danych
plots_df <- data.frame()

# Dla każdej nazwy kraju na liście złożonej z ciągów bajtów...
for (country_name in names(plots_str_vec_lst)) {
  
  # ...wyodrębnij listę fragmentów
  plt_vec = plots_str_vec_lst[[country_name]]
  
  # i wypełnij ją tymczasową ramką danych
  tmp_df <- data.frame(
    country_name = rep(country_name, length(plt_vec)),
    chunk_id = seq(1,length(plt_vec),1),
    plot_str = plt_vec,
    
    stringsAsFactors = FALSE
  )
  
  # Następnie dołącz tymczasową ramkę danych
  # do ramki głównej (rbind = rows bind)
  plots_df <- rbind(plots_df, tmp_df)
  
}

