
library(tidyverse)

# Załaduj zestaw danych 'population'
# dostarczony przez pakiet tidyr
data("population")

# Rzućmy okiem na tibble
population

# Spójrzmy na kraje
population %>% 
  
  # Uzyskaj różne wartości z 'country'
  # Wynik to obiekt tibble złożony z jednej kolumny
  distinct(country) %>% 
  
  # "Odłącz" odrębną kolumnę od obiektu tibble
  # i przekształć ją w wektor
  pull()

# Zagnieżdżamy dane roku ('year') i populacji ('population')
# do innego obiektu tibble dla każdego kraju
nested_population_tbl <- population %>% 
  tidyr::nest( demographic_data = -country )

# Rzućmy okiem na tibble
# Należy zauważyć, że kolumna zagnieżdżona jest
# listą obiektów tibble
nested_population_tbl

# Serializujemy zagnieżdżony obiekt tibble populacji
# do pliku RDL w celu jego współdzielenia
saveRDS(nested_population_tbl, "nested_population_tbl.rds")

