import unittest
import os

class TestMyApp(unittest.TestCase):

	def setUp(self):
		# Jeżeli zmienna HTPP_SERVER jest zdefiniowana, zostanie wykorzystana jako punkt końcowy.
		http_app = os.environ.get('HTTP_SERVER')
		if http_app is not None:
			from webtest import TestApp
			self.app = TestApp(http_app)
		else:
			# Wywołanie aplikacji WSGI.
			from flask_basic import app
			from flask_webtest import TestApp
			self.app = TestApp(app)
	
	def test_help(self):
		# Wysłanie zapytania ze ścieżką /api/.
		hello = self.app.get('/api')

		# Sprawdzenie treści odpowiedzi.
		self.assertEqual(hello.json['Witaj,'], 'świecie!')

if __name__ == '__main__':
	unittest.main()