package Pytanie11_3;

public class Pytanie {
	public static int search(int a[], int left, int right, int x) {
		int mid = (left + right) / 2;
		if (x == a[mid]) { // Znaleziono element
			return mid;
		}
		if (right < left) {
			return -1;
		}
		
		/* Choć z powodu rotacji może występować punkt przeskoku wartości, lewa lub prawa 
		 * połowa muszą być poprawnie uporządkowane. Można sprawdzić poprawnie uporządkowaną połowę,
		 * aby ustalić, którą z połówek należy przeszukać
		 */
		if (a[left] < a[mid]) { // Lewa strona jest poprawnie uporządkowana
			if (x >= a[left] && x <= a[mid]) { 
				return search(a, left, mid - 1, x);
			} else {
				return search(a, mid + 1, right, x);
			}
		} else if (a[mid] < a[left]) { // Prawa strona jest poprawnie uporządkowana
			if (x >= a[mid] && x <= a[right]) {
				return search(a, mid + 1, right, x);
			} else {
				return search(a, left, mid - 1, x);
			}				
		} else if (a[left] == a[mid]) { // Lewa strona zawiera same powtórzenia LUB 
		// prawa strona się zawija (wtedy prawa połowa zawiera same duplikaty)
			if (a[mid] != a[right]) { // Jeśli prawa strona się nie zawija, należy przeszukać tę połowę
				return search(a, mid + 1, right, x);
			} else { // W przeciwnym razie należy przeszukać obie połówki
				int result = search(a, left, mid - 1, x); 
				if (result == -1) {
					return search(a, mid + 1, right, x); 
				} else {
					return result;
				}
			}
		}
		return -1;
	}

	public static void main(String[] args) {
		int[] a = { 2, 3, 2, 2, 2, 2, 2, 2 , 2 , 2 };

		System.out.println(search(a, 0, a.length - 1, 2));
		System.out.println(search(a, 0, a.length - 1, 3));
		System.out.println(search(a, 0, a.length - 1, 4));
		System.out.println(search(a, 0, a.length - 1, 1));
		System.out.println(search(a, 0, a.length - 1, 8));
	}

}
