package Pytanie18_10;

import java.awt.List;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Pytanie {

	public static LinkedList<String> transform(String startWord, String stopWord, Set<String> dictionary) {
		startWord = startWord.toUpperCase();
		stopWord = stopWord.toUpperCase();
		Queue<String> actionQueue = new LinkedList<String>();
		Set<String> visitedSet = new HashSet<String>();
		Map<String, String> backtrackMap = new TreeMap<String, String>();

		actionQueue.add(startWord);
		visitedSet.add(startWord);

		while (!actionQueue.isEmpty()) {
			String w = actionQueue.poll();
			// Dla każdego słowa v, które można uzyskać z w za pomocą zmiany jednej litery
			for (String v : getOneEditWords(w)) {
				if (v.equals(stopWord)) {
					// Znaleziono słowo! Teraz należy się cofnąć
					LinkedList<String> list = new LinkedList<String>();
					// Dołączanie v do listy
					list.add(v);
					while (w != null) {
						list.add(0, w);
						w = backtrackMap.get(w);
					}
					return list;
				}

				// Jeśli v znajduje się w słowniku
				if (dictionary.contains(v)) {
					if (!visitedSet.contains(v)) {
						actionQueue.add(v);
						visitedSet.add(v); // Oznaczanie jako odwiedzonego
						backtrackMap.put(v, w);
					}
				}
			}
		}
		return null;
	}

	private static Set<String> getOneEditWords(String word) {
		Set<String> words = new TreeSet<String>();
		// Dla każdej litery
		for (int i = 0; i < word.length(); i++) {
			char[] wordArray = word.toCharArray();
			// Należy zmienić tę literę na inną
			for (char c = 'A'; c <= 'Z'; c++) {
				if (c != word.charAt(i)) {
					wordArray[i] = c;
					words.add(new String(wordArray));
				}
			}
		}
		return words;
	}
	
	public static HashSet<String> setupDictionary(String[] words) {
		HashSet<String> hash = new HashSet<String>();
		for (String word : words) {
			hash.add(word.toUpperCase());
		}
		return hash;
	}

	public static void main(String[] args) {
		String[] words = {"maps", "tan", "tree", "apple", "cans", "help", "aped", "free", "apes", "flat", "trap", "fret", "trip", "trie", "frat", "fril"};
		HashSet<String> dict = setupDictionary(words);
		LinkedList<String> list = transform("tree", "flat", dict);
		for (String word : list) {
			System.out.println(word);
		}
	}

}
