package Pytanie7_5;

public class Square {
	public double left;
	public double top;
	public double bottom;
	public double right;
	public double size;
	public Square(double left, double top, double size) {
		this.left = left;
		this.top = top;
		this.bottom = top + size;
		this.right = left + size;
		this.size = size;
	}
	
	public Point middle() {
		return new Point((this.left + this.right)/2.0, (this.top + this.bottom)/2.0);
	}
	
	public boolean contains(Square other) {
		if (this.left <= other.left && this.right >= other.right && this.top <= other.top && this.bottom >= other.bottom) {
			return true;
		}
		return false;
	}
	
	/* Zwracanie punktu, w ktrym fragment linii czcej punkty mid1 i
	 * mid2 przecina krawd pierwszego kwadratu. Odpowiada to rysowaniu
	 * linii z mid2 do mid1 i kontynuowaniu jej do momentu napotkania
	 * krawdzi kwadratu */
	public Point extend(Point mid1, Point mid2, double size) {
		/* Find what direction the line mid2 -> mid1 goes */
		double xdir = mid1.x < mid2.x ? -1 : 1;
		double ydir = mid1.y < mid2.y ? -1 : 1;
		
		/* Jeli mid1 i mid2 maj t sam warto x, przy obliczaniu 
		 * nachylenia zgoszony zostanie wyjtek dzielenia przez 0. Dlatego
		 * trzeba dla tego przypadku przeprowadzi specjalne obliczenia  */
		if (mid1.x == mid2.x) {
			return new Point(mid1.x, mid1.y + ydir * size / 2.0);
		}
		double slope = (mid1.y - mid2.y) / (mid1.x - mid2.x);
		double x1 = 0;
		double y1 = 0;
		
		/* Obliczanie nachylenia za pomoc rwnania (y1 - y2) / (x1 - x2).
		 * Uwaga: jeli nachylenie jest due (>1), koniec fragmentu
		 * linii przetnie krawd o (size / 2) jednostek od rodka wzgldem
		 * osi y. Przy maym nachyleniu (<1) koniec fragmentu linii
		 * przetnie krawd o (size / 2) jednostek od rodka 
		 * wzgldem osi x  */
		if (Math.abs(slope) == 1) {
			x1 = mid1.x + xdir * size / 2.0;
			y1 = mid1.y + ydir * size / 2.0;
		} else if (Math.abs(slope) < 1) {
			x1 = mid1.x + xdir * size / 2.0;
			y1 = slope * (x1 - mid1.x) + mid1.y; 
		} else {
			y1 = mid1.y + ydir * size / 2.0;
			x1 = (y1 - mid1.y) / slope + mid1.x;
		}
		return new Point(x1, y1);
	}
	
	public Line cut(Square other) {
		/* Obliczanie, w ktrym miejscu linia przetnie si z krawdziami midzy rodkami kwadratw */
		Point p1 = extend(this.middle(), other.middle(), this.size);
		Point p2 = extend(this.middle(), other.middle(), -1 * this.size);
		Point p3 = extend(other.middle(), this.middle(), other.size);
		Point p4 = extend(other.middle(), this.middle(), -1 * other.size);
	
		/* Na podstawie tych punktw znajdowane s pocztek i koniec linii. Pocztek to punkt
		 * pierwszy od lewej (lub pierwszy od gry w przypadku tych samych wartoci), a koniec to 
		 * punkt pierwszy od prawej (lub pierwszy od dou w przypadku tych samych wartoci) 
		 */
		Point start = p1;
		Point end = p1;		
		Point[] points = {p2, p3, p4};
		for (int i = 0; i < points.length; i++) {
			if (points[i].x < start.x || (points[i].x == start.x && points[i].y < start.y)) {
				start = points[i];
			} else if (points[i].x > end.x || (points[i].x == end.x && points[i].y > end.y)) {
				end = points[i];
			}
		}
			
		return new Line(start, end);
	}
	
	public String toString() {
		return "(" + left + ", " + top + ")|(" + right + "," + bottom + ")";
	}
}
